#include <iostream>
#include <set>
#include <sstream>
#include <cstdlib>
#include <fstream>

#include <lemon/list_graph.h>

#include "tsp.h"

using namespace std;
using namespace lemon;

struct TestEOL { bool operator()(char c) { return c == '\n'; } };

void readMatrix(const string& filename, ListGraph& g, ListGraph::EdgeMap<int>& weight)
{ // could be nicer, but don't care...
	g.clear();
	// get number of lines / nodes
	fstream f(filename);
	TestEOL test;
	int count = count_if(istreambuf_iterator<char>(f), istreambuf_iterator<char>(), test);
	
	ListGraph::Node* nodes;
	nodes = new ListGraph::Node[count];
	
	for (int i = 0; i < count; i++) nodes[i] = g.addNode();
	
	ifstream file;
	file.open(filename);
	
	int tmp;
	for (int i = 0; i < count; i++)
	{
		for (int j = 0; j < count; j++)
		{
			file >> ws >> tmp;
			if (i < j)
			{
				ListGraph::Edge e = g.addEdge(nodes[i], nodes[j]);
				weight[e] = tmp;
			}
		}
	}		
	file.close();
	delete[] nodes;
}

int main()
{
	ListGraph g;
	ListGraph::EdgeMap<int> weight(g);
	readMatrix("matrix.txt", g, weight);
	TSP tsp(g, weight);
	tsp.tsp();
}
