#include "prim.h"

#include <set>
#include <queue>

using namespace std;
using namespace lemon;

struct cmpEdge
{
	ListGraph::Edge e;
	int w;
	
	cmpEdge(const ListGraph::Edge& e, const int w):
		e(e),
		w(w)
		{}
	cmpEdge(const cmpEdge& edge):
		e(edge.e),
		w(edge.w)
		{}
	
	bool operator<(const cmpEdge& e) const
	{
		return this->w > e.w;
	}
};

int Prim::prim()
{
	set<ListGraph::Node> vertices;
	priority_queue<cmpEdge> edges;
	
	if (this->mst != 0) delete this->mst;
	this->mst = new set<ListGraph::Edge>();
	
	ListGraph::NodeIt n(this->g);
	vertices.insert(n);
	ListGraph::Node cur = n;
	
	int weight = 0;
	
	while (vertices.size() < (unsigned int)countNodes(this->g))
	{
		// add all edges from cur node
		for (ListGraph::IncEdgeIt e(this->g, cur); e != INVALID; ++e)
		{
			ListGraph::Edge edge = e;
			edges.push(cmpEdge(edge, this->weight[edge]));
		}
		
		// find best edge
		ListGraph::Edge best;
		ListGraph::Node next;
		int curw = 0;
		do
		{
			if (edges.size() == 0)
			{
				cerr << "edges.size() == 0. it seems the graph is not connected..." << endl;
				exit(1);
			}
			best = edges.top().e;
			curw = edges.top().w;
			edges.pop();
			next = this->g.u(best);
			if (vertices.count(next)) next = this->g.v(best);
		} // drop edge if it would close a cycle
		while (vertices.count(next) > 0);
		
		// add to mst
		vertices.insert(next);
		this->mst->insert(best);
		weight += curw;
		cur = next;
	}
	return weight;
}
