#include "tsp.h"

#include "prim.h"
#include <lemon/matching.h>
#include <lemon/core.h>
#include <lemon/euler.h>
#include <list>
#include <iostream>

int TSP::degree(const ListGraph& g, const ListGraph::Node& n, const set<ListGraph::Edge>& edges, const ListGraph::NodeMap<ListGraph::Node>& mapping)
{
	int deg = 0;
	for (set<ListGraph::Edge>::iterator it = edges.begin(); it != edges.end(); ++it)
	{
		if (mapping[g.u(*it)] == n) deg++;
		if (mapping[g.v(*it)] == n) deg++;
	}
	return deg;
}

int TSP::tsp()
{
	if (this->edges != 0) delete this->edges;
	this->edges = new set<ListGraph::Edge>();

	// calculate mst
	Prim p(this->g, this->weight);
	p.prim();
	
	// copy subgraph induced by vertices with odd degree: create copy, run GraphCopy
	ListGraph matchg;
	ListGraph::EdgeMap<ListGraph::Edge> edgemap(this->g);
	ListGraph::NodeMap<ListGraph::Node> nodemap(this->g);
	ListGraph::EdgeMap<int> matchw(matchg);
	
	GraphCopy<ListGraph, ListGraph> copy(this->g, matchg);
	copy.edgeRef(edgemap).nodeRef(nodemap).edgeMap(this->weight, matchw);
	copy.run();
	
	// and now remove all edges with even degree	
	ListGraph::Node node;
	for (ListGraph::NodeIt n(matchg); n != INVALID; )
	{ // erase nodes with even degree
		if (this->degree(this->g, n, *p.mst, nodemap) % 2 == 0)
		{ // just removing the node that the iterator is pointing at puts iterator in undefined state
			node = n;
			++n;
			matchg.erase(node);
		}
		else ++n;
	}
	
	// convert max matching to min matching
	for (ListGraph::EdgeIt e(matchg); e != INVALID; ++e)
	{ 
		matchw[e] = -matchw[e];
	}
	// calculate matching on remaining nodes
	MaxWeightedPerfectMatching<ListGraph, ListGraph::EdgeMap<int>> m(matchg, matchw);
	m.run();
	
	// now create another graph copy that contains the mst edges and the matching edges
	// we will search a eulerian path in this graph afterwards
	ListGraph eulerg;
	ListGraph::EdgeMap<ListGraph::Edge> eulermap(eulerg);
	ListGraph::NodeMap<ListGraph::Node> eulernodemap(eulerg);
	ListGraph::NodeMap<bool> visited(eulerg);
	
	GraphCopy<ListGraph, ListGraph> copy2(this->g, eulerg);
	copy2.nodeCrossRef(eulernodemap).edgeCrossRef(eulermap).run();
	
	// make a copy of the edges as removing the iterator is even uglier than above...
	list<ListGraph::Edge> edges;
	for (ListGraph::EdgeIt e(eulerg); e != INVALID; ++e) edges.push_back(e);
	
	for (list<ListGraph::Edge>::iterator it = edges.begin(); it != edges.end(); ++it)
	{ // copy edges in matching
	
		ListGraph::Edge cur = edgemap[eulermap[*it]];
		if (m.matching(cur))
		{
			eulerg.addEdge(eulerg.u(*it), eulerg.v(*it));
		}
		if (p.mst->count(eulermap[*it]) == 0) eulerg.erase(*it);
	}
	
	return 0;
}