#include <graph_displayer_canvas.h>

GraphDisplayerCanvas::GraphDisplayerCanvas(Graph & gr, CoordinatesMap & cm, MapStorage & ms):g(gr),nodesmap(g),edgesmap(g),edgetextmap(g),displayed_graph(*(root()), 0, 0),mapstorage(ms),isbutton(false),active_item(NULL)
{

  for (EdgeIt i(g); i!=INVALID; ++i)
  {
    Gnome::Canvas::Points coos;
    coos.push_back(Gnome::Art::Point(cm[g.source(i)].x,cm[g.source(i)].y));
    coos.push_back(Gnome::Art::Point(cm[g.target(i)].x,cm[g.target(i)].y));
    
    edgesmap[i]=new Gnome::Canvas::Line(displayed_graph, coos);
    *(edgesmap[i]) << Gnome::Canvas::Properties::fill_color("green");
    edgesmap[i]->property_width_pixels().set_value(10);
    
    
    double x1, x2, y1, y2;
    edgesmap[i]->get_bounds(x1, y1, x2, y2);
    
    edgetextmap[i]=new Gnome::Canvas::Text(displayed_graph,(x1+x2)/2, (y1+y2)/2, "");
    edgetextmap[i]->property_fill_color().set_value("black");
  }

  NodeIt i(g);
  int maxx=0, maxy=0, minx=(int)cm[i].x, miny=(int)cm[i].y;

  for (; i!=INVALID; ++i)
  {
    if(cm[i].x>maxx)maxx=(int)cm[i].x;
    if(cm[i].y>maxy)maxy=(int)cm[i].y;
    if(cm[i].x<minx)minx=(int)cm[i].x;
    if(cm[i].y<miny)miny=(int)cm[i].y;

    nodesmap[i]=new Gnome::Canvas::Ellipse(displayed_graph, cm[i].x-20, cm[i].y-20, cm[i].x+20, cm[i].y+20);
    *(nodesmap[i]) << Gnome::Canvas::Properties::fill_color("blue");
    *(nodesmap[i]) << Gnome::Canvas::Properties::outline_color("black");
    (nodesmap[i])->signal_event().connect(sigc::bind(sigc::mem_fun(*this, &GraphDisplayerCanvas::event_handler),i));
  }

  double biggest_x=(abs(maxx)>abs(minx))?(abs(maxx)+80):(abs(minx)+80);
  double biggest_y=(abs(maxy)>abs(miny))?(abs(maxy)+80):(abs(miny)+80);

  set_pixels_per_unit((biggest_x>biggest_y)?(WIN_WIDTH/biggest_x/2):(WIN_HEIGHT/biggest_y/2));
  std::cout<<abs(maxx)<<" "<<abs(minx)<<" big x "<<biggest_x<<" "<<abs(maxy)<<" "<<abs(miny)<<" big y "<<biggest_y<<std::endl;
  std::cout<<maxx<<" "<<minx<<" big x "<<biggest_x<<" "<<maxy<<" "<<miny<<" big y "<<biggest_y<<std::endl;
  std::cout<<"dx "<<(maxx-minx)<<" dy "<<(maxy-miny)<<" xrate "<<((maxx-minx)/WIN_WIDTH)<<" yrate "<<((maxy-miny)/WIN_HEIGHT)<<std::endl;

}

GraphDisplayerCanvas::~GraphDisplayerCanvas()
{
    Graph::NodeMap <int> id(g);
    Graph::NodeMap <double> xc(g);
    Graph::NodeMap <double> yc(g);

    int j=1;

    for (NodeIt i(g); i!=INVALID; ++i)
    {
        double x1,y1,x2,y2;
        nodesmap[i]->get_bounds(x1, y1, x2, y2);

        id[i]=j++;
        xc[i]=(x1+x2)/2;
        yc[i]=(y1+y2)/2;
    }

    GraphWriter<Graph> writer(std::cout,g);

    writer.writeNodeMap("id", id);
    writer.writeNodeMap("coordinates_x", xc);
    writer.writeNodeMap("coordinates_y", yc);
    writer.run();
}

int GraphDisplayerCanvas::changeLineWidth (std::string mapname)
{
  for (EdgeIt i(g); i!=INVALID; ++i)
  {
    int w=(int)(*(mapstorage.edgemap_storage)[mapname])[i];
    edgesmap[i]->property_width_pixels().set_value(w);
  }
  return 0;
};

int GraphDisplayerCanvas::changeColor (std::string mapname)
{  
  for (EdgeIt i(g); i!=INVALID; ++i)
  {
    double w=(*(mapstorage.edgemap_storage)[mapname])[i];
    double max=mapstorage.maxOfEdgeMap(mapname);
    double min=mapstorage.minOfEdgeMap(mapname);
      
    //std::cout<<w<<" "<<max<<" "<<min<<" "<<100*(w-min)/(max-min)<<std::endl;
    Gdk::Color color;
    if(max!=min)
    {
      color.set_rgb_p (0, 100*(w-min)/(max-min), 0);
    }
    else
    {
      color.set_rgb_p (0, 100, 0);
    }

    edgesmap[i]->property_fill_color_gdk().set_value(color);
  }
  return 0;
};

int GraphDisplayerCanvas::changeText (std::string mapname)
{
  for (EdgeIt i(g); i!=INVALID; ++i)
  {
    if(mapname!="Text")
    {
      double number=(*(mapstorage.edgemap_storage)[mapname])[i];
      int length=(int)(floor(log(number)/log(10)))+1;
      int maxpos=(int)(pow(10,length-1));
      int strl=length+1+RANGE;
      char * str=new char[strl];
      str[length]='.';
      str[strl]='\0';
      
      for(int j=0;j<strl;j++)
      {
	if(j!=length)
        {
	  int digit=(int)(number/maxpos);
	  str[j]=(digit+'0');
	  number-=digit*maxpos;
	  number*=10;
        }
      }
      
      edgetextmap[i]->property_text().set_value(str);
    }
    else
    {
      edgetextmap[i]->property_text().set_value("");
    }
  }
  return 0;
};


int GraphDisplayerCanvas::rezoom ()
{
  double x1, x2, y1, y2;
  int x,y;

  NodeIt i(g);
  nodesmap[i]->get_bounds(x1, y1, x2, y2);

  x=(int)((x1+x2)/2);
  y=(int)((y1+y2)/2);
  
  int maxx=0, maxy=0, minx=(int)x, miny=(int)y;

  for (; i!=INVALID; ++i)
  {
    nodesmap[i]->get_bounds(x1, y1, x2, y2);

    x=(int)((x1+x2)/2);
    y=(int)((y1+y2)/2);

    if(x>maxx)maxx=x;
    if(y>maxy)maxy=y;
    if(x<minx)minx=x;
    if(y<miny)miny=y;
  }

  double biggest_x=(abs(maxx)>abs(minx))?(abs(maxx)+80):(abs(minx)+80);
  double biggest_y=(abs(maxy)>abs(miny))?(abs(maxy)+80):(abs(miny)+80);

  set_pixels_per_unit((biggest_x-WIN_WIDTH>biggest_y-WIN_HEIGHT)?(WIN_WIDTH/biggest_x/2):(WIN_HEIGHT/biggest_y/2));
  return 0;
};


///This function moves only one node of displayed_graph,
///but recalculate the location of weight point,
///and also redraw the sides of the planefigure.
bool GraphDisplayerCanvas::event_handler(GdkEvent* e, Node n)
{
  switch(e->type)
  {
    case GDK_BUTTON_PRESS:
      clicked_x=e->button.x;
      clicked_y=e->button.y;
      active_item=(get_item_at(e->button.x, e->button.y));
      isbutton=true;
      break;
    case GDK_BUTTON_RELEASE:
      isbutton=false;
      active_item=NULL;
      break;
    case GDK_MOTION_NOTIFY:
      if(isbutton)
      {
        double dx=e->motion.x-clicked_x;
        double dy=e->motion.y-clicked_y;
        active_item->move(dx, dy);
        clicked_x=e->motion.x;
        clicked_y=e->motion.y;

        EdgeIt e;

        g.firstOut(e,n);
        for(;e!=INVALID;g.nextOut(e))
        {
            Gnome::Canvas::Points coos;
            double x1, x2, y1, y2;

            nodesmap[g.source(e)]->get_bounds(x1, y1, x2, y2);
            coos.push_back(Gnome::Art::Point((x1+x2)/2,(y1+y2)/2));

            nodesmap[g.target(e)]->get_bounds(x1, y1, x2, y2);
            coos.push_back(Gnome::Art::Point((x1+x2)/2,(y1+y2)/2));

            edgesmap[e]->property_points().set_value(coos);

	    edgesmap[e]->get_bounds(x1, y1, x2, y2);

	    edgetextmap[e]->property_x().set_value((x1+x2)/2);
	    edgetextmap[e]->property_y().set_value((y1+y2)/2);
        }

        g.firstIn(e,n);
        for(;e!=INVALID;g.nextIn(e))
        {
            Gnome::Canvas::Points coos;
            double x1, x2, y1, y2;

            nodesmap[g.source(e)]->get_bounds(x1, y1, x2, y2);
            coos.push_back(Gnome::Art::Point((x1+x2)/2,(y1+y2)/2));

            nodesmap[g.target(e)]->get_bounds(x1, y1, x2, y2);
            coos.push_back(Gnome::Art::Point((x1+x2)/2,(y1+y2)/2));

            edgesmap[e]->property_points().set_value(coos);

	    edgesmap[e]->get_bounds(x1, y1, x2, y2);

	    edgetextmap[e]->property_x().set_value((x1+x2)/2);
	    edgetextmap[e]->property_y().set_value((y1+y2)/2);
        }
      }
    default: break;
  }
  return true;
}

bool GraphDisplayerCanvas::on_expose_event(GdkEventExpose *event)
{
  Gnome::Canvas::CanvasAA::on_expose_event(event);
  //usleep(10000);
  //rezoom();
  return true;
}
