#include <main_win.h>

MainWin::MainWin(const std::string& title, Graph & graph, CoordinatesMap & cm, MapStorage & ms):mapwin("Map Setup", ms, gd_canvas),gd_canvas(graph, cm, ms)
{
  set_title (title);
  set_default_size(WIN_WIDTH,WIN_HEIGHT);
  add(vbox);

  ag=Gtk::ActionGroup::create();
  ag->add( Gtk::Action::create("ShowMenu", "_Show") );
  ag->add( Gtk::Action::create("ShowMaps", "_Maps"), sigc::mem_fun(*this, &MainWin::showMaps));
  ag->add( Gtk::Action::create("FileMenu", "_File") );
  ag->add( Gtk::Action::create("FileQuit", "_Quit"), sigc::mem_fun(*this, &MainWin::quit));
  ag->add( Gtk::Action::create("ZoomMenu", "_Zoom") );
  ag->add( Gtk::Action::create("ZoomRezoom", "_Rezoom"), sigc::mem_fun(*this, &MainWin::rezoom)); //!!!!!!

  uim=Gtk::UIManager::create();
  uim->insert_action_group(ag);
  add_accel_group(uim->get_accel_group());

  try
  {

    Glib::ustring ui_info =
      "<ui>"
      "  <menubar name='MenuBar'>"
      "    <menu action='FileMenu'>"
      "      <menuitem action='FileQuit'/>"
      "    </menu>"
      "    <menu action='ShowMenu'>"
      "      <menuitem action='ShowMaps'/>"
      "    </menu>"
      "    <menu action='ZoomMenu'>"
      "      <menuitem action='ZoomRezoom'/>"
      "    </menu>"
      "  </menubar>"
      "</ui>";

    uim->add_ui_from_string(ui_info);

  }
  catch(const Glib::Error& ex)
  {
    std::cerr << "building menus failed: " <<  ex.what();
  }

  Gtk::Widget* menubar = uim->get_widget("/MenuBar");
  if(menubar)vbox.pack_start(*menubar, Gtk::PACK_SHRINK);

  vbox.pack_start(gd_canvas);

  show_all_children();
}

void MainWin::showMaps()
{
  mapwin.show();
}

void MainWin::quit()
{
  hide();
}

void MainWin::rezoom()
{
  gd_canvas.rezoom();
}

