#include <mapstorage.h>

MapStorage::MapStorage(Graph & graph):g(graph)
{
  for(int i=0;i<PROPERTY_NUM;i++)
  {
    Graph::EdgeMap<double> emd(g);
    default_edgemaps.push_back(emd);
    Graph::NodeMap<double> nmd(g);
    default_nodemaps.push_back(nmd);
  }

  //std::string defaultstr="Default ";
  for(int i=0;i<PROPERTY_NUM;i++)
  {
      for (EdgeIt j(g); j!=INVALID; ++j)
      {
	(default_edgemaps[i])[j]=property_defaults[i];
      }
      addEdgeMap(property_strings[i],&(default_edgemaps[i]));
  }

};

int MapStorage::addNodeMap(const std::string & name, Graph::NodeMap<double> *nodemap)
{
  nodemap_storage[name]=nodemap;
  return 0;
}
int MapStorage::addEdgeMap(const std::string & name, Graph::EdgeMap<double> *edgemap)
{
  edgemap_storage[name]=edgemap;
  return 0;
}

double MapStorage::maxOfNodeMap(const std::string & name)
{
  double max=0;
  for (NodeIt j(g); j!=INVALID; ++j)
  {
    if( (*nodemap_storage[name])[j]>max )
    {
      max=(*nodemap_storage[name])[j];
    }
  }
  return max;
}

double MapStorage::maxOfEdgeMap(const std::string & name)
{
  double max=0;
  for (EdgeIt j(g); j!=INVALID; ++j)
  {
    if( (*edgemap_storage[name])[j]>max )
    {
      max=(*edgemap_storage[name])[j];
    }
  }
  return max;
}

double MapStorage::minOfNodeMap(const std::string & name)
{
  NodeIt j(g);
  double min=(*nodemap_storage[name])[j];
  for (; j!=INVALID; ++j)
  {
    if( (*nodemap_storage[name])[j]<min )
    {
      min=(*nodemap_storage[name])[j];
    }
  }
  return min;
}

double MapStorage::minOfEdgeMap(const std::string & name)
{
  EdgeIt j(g);
  double min=(*edgemap_storage[name])[j];
  for (EdgeIt j(g); j!=INVALID; ++j)
  {
    if( (*edgemap_storage[name])[j]<min )
    {
      min=(*edgemap_storage[name])[j];
    }
  }
  return min;
}

