// -*- C++ -*- //

#ifndef MAPSTORAGE_H
#define MAPSTORAGE_H

#include <all_include.h>

class MapStorage
{

public: ///!!!!!!!!
  Graph g;
  std::map< std::string,Graph::NodeMap<double> * > nodemap_storage;
  std::map< std::string,Graph::EdgeMap<double> * > edgemap_storage;

  std::vector<Graph::NodeMap<double> > default_nodemaps;
  std::vector<Graph::EdgeMap<double> > default_edgemaps;

public:
  MapStorage(Graph &);
  int addNodeMap(const std::string &,Graph::NodeMap<double> *);
  int addEdgeMap(const std::string &,Graph::EdgeMap<double> *);

  int numOfNodeMaps() {return nodemap_storage.size();};
  int numOfEdgeMaps() {return edgemap_storage.size();};

  double maxOfNodeMap(const std::string &);
  double maxOfEdgeMap(const std::string &);

  double minOfNodeMap(const std::string &);
  double minOfEdgeMap(const std::string &);

  std::map< std::string,Graph::NodeMap<double> * >::iterator beginOfNodeMaps(){return nodemap_storage.begin();};
  std::map< std::string,Graph::EdgeMap<double> * >::iterator beginOfEdgeMaps(){return edgemap_storage.begin();};
};

#endif //MAPSTORAGE_H
