#include <iostream>
#include <fstream>

#include <list_graph.hh>
#include <dimacs.hh>
#include <edmonds_karp.hh>
#include <time_measure.h>

using namespace hugo;

// Use a DIMACS max flow file as stdin.
// read_dimacs_demo < dimacs_max_flow_file
int main(int, char **) {
  typedef ListGraph::NodeIt NodeIt;
  typedef ListGraph::EachEdgeIt EachEdgeIt;

  ListGraph G;
  NodeIt s, t;
  ListGraph::EdgeMap<int> cap(G);
  readDimacsMaxFlow(std::cin, G, s, t, cap);

/*
  double pre_time_copy=currTime();
  ListGraph F;
  ListGraph::NodeMap<NodeIt> G_to_F(G);
  typedef ListGraph::EachNodeIt EachNodeIt;
  for(EachNodeIt n=G.first<EachNodeIt>(); n.valid(); ++n) {
    G_to_F.set(n, F.addNode());
  }
  for(EachEdgeIt e=G.first<EachEdgeIt>(); e.valid(); ++e) {
    F.addEdge(G_to_F.get(G.tail(e)), G_to_F.get(G.head(e)));
  }
  double post_time_copy=currTime();
  std::cout << "copy time: " << post_time_copy-pre_time_copy << " sec"<< std::endl; 
*/

  std::cout << "edmonds karp demo..." << std::endl;
  ListGraph::EdgeMap<int> flow(G); //0 flow

  double pre_time=currTime();
  MaxFlow<ListGraph, int, ListGraph::EdgeMap<int>, ListGraph::EdgeMap<int> > max_flow_test(G, s, t, flow, cap);
  max_flow_test.augmentWithBlockingFlow();
  max_flow_test.run();
  double post_time=currTime();
  //std::cout << "maximum flow: "<< std::endl;
  //for(EachEdgeIt e=G.first<EachEdgeIt>(); e.valid(); ++e) { 
  //  std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
  //}
  //std::cout<<std::endl;
  std::cout << "elapsed time: " << post_time-pre_time << " sec"<< std::endl; 
  std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;

  return 0;
}
