#include <iostream>
#include <fstream>

#include "smart_graph.h"

#include "../list_graph.hh"
#include "../marci/dimacs.hh"
#include "f_ed_ka.h"
#include "../marci/time_measure.h"

using namespace marci;

// Use a DIMACS max flow file as stdin.
// read_dimacs_demo < dimacs_max_flow_file

int main(int, char **) {
  //  typedef SmartGraph Graph;
  typedef ListGraph Graph;

  typedef Graph::NodeIt NodeIt;
  typedef Graph::EachNodeIt EachNodeIt;
  typedef Graph::EachEdgeIt EachEdgeIt;

  Graph G;
  NodeIt s, t;
  Graph::EdgeMap<int> cap(G);
  readDimacsMaxFlow(std::cin, G, s, t, cap);

  std::cout << "edmonds karp demo..." << std::endl;
  Graph::EdgeMap<int> flow(G); //0 flow
  
  int ret;
  double pre_time=currTime();
  ret = maxFlow(G,flow,cap,s,t);
  double post_time=currTime();
  //std::cout << "maximum flow: "<< std::endl;
  //for(EachEdgeIt e=G.first<EachEdgeIt>(); e.valid(); ++e) { 
  //  std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
  //}
  //std::cout<<std::endl;
  std::cout << "elapsed time: " << post_time-pre_time << " sec"<< std::endl; 
  std::cout << "flow value: "<< ret << std::endl;

  return 0;
}
