// -*- mode:C++ -*-

#ifndef HUGO_INVALID_H
#define HUGO_INVALID_H

namespace hugo {

  /// Dummy type to make it easier to make invalid iterators.
  
  /// See \ref INVALID, how to use it.
  
  struct Invalid {};
  
  /// Invalid iterators.
  
  /// \ref Invalid is a global type that converts to each iterator
  /// in such a way that the value of the target iterator will be invalid.

  // It is also used to convert the \c INVALID constant to the
  // node iterator that makes is possible to write 

  //extern Invalid INVALID;

  //const Invalid &INVALID = *(Invalid *)0;
  const Invalid INVALID = Invalid();

};

#endif
  
