// -*- C++ -*-
/* 
 *template <Graph, T, Heap=FibHeap, LengthMap=Graph::EdgeMap<T> >
 *
 *Constructor: 
 *
 *Dijkstra(Graph G, LengthMap length)
 *
 *
 *Methods:
 *
 *void run(Node s)
 *
 *T dist(Node v) : After run(s) was run, it returns the distance from s to v. 
 *   Returns T() if v is not reachable from s.
 *
 *Edge pred(Node v) : After run(s) was run, it returns the last 
 *   edge of a shortest s-v path. It is INVALID for s and for 
 *   the nodes not reachable from s.
 *
 *bool reached(Node v) : After run(s) was run, it is true iff v is 
 *   reachable from s
 *
 */

#ifndef HUGO_DIJKSTRA_H
#define HUGO_DIJKSTRA_H

#include <fib_heap.h>
#include <invalid.h>

namespace hugo {
  
  //Alpar: Changed the order of the parameters
  template <typename Graph,
	    typename LengthMap=typename Graph::EdgeMap<int>,
	    typename Heap=FibHeap<typename Graph::Node,
				  typename LengthMap::ValueType, 
				  typename Graph::NodeMap<int> > >
  class Dijkstra{
  public:
    typedef typename LengthMap::ValueType ValueType;

  private:
    typedef typename Graph::Node Node;
    typedef typename Graph::NodeIt NodeIt;
    typedef typename Graph::Edge Edge;
    typedef typename Graph::OutEdgeIt OutEdgeIt;
    
    const Graph& G;
    const LengthMap& length;
    typedef typename Graph::NodeMap<Edge> PredMap;
    PredMap predecessor;
    //In place of reach:
    typedef typename Graph::NodeMap<Node> PredNodeMap;
    PredNodeMap pred_node;
    typedef typename Graph::NodeMap<ValueType> DistMap;
    DistMap distance;
    //I don't like this:
    //     //FIXME:
    //     typename Graph::NodeMap<bool> reach;
    //     //typename Graph::NodeMap<int> reach;
    
  public :
    
    /*
      The distance of the nodes is 0.
    */
    Dijkstra(Graph& _G, LengthMap& _length) :
      G(_G), length(_length), predecessor(_G), pred_node(_G), distance(_G) { }
    

    void run(Node s);
    
    ValueType dist(Node v) const { return distance[v]; }
    Edge pred(Node v) const { return predecessor[v]; }
    Node predNode(Node v) const { return pred_node[v]; }
    
    const DistMap &distMap() const { return distance;}
    const PredMap &predMap() const { return predecessor;}
    const PredNodeMap &predNodeMap() const { return pred_node;}

    //    bool reached(Node v) { return reach[v]; }
    ///\warning \c s is not reached!
    ///
    bool reached(Node v) { return G.valid(predecessor[v]); }
    
  };
  

  // IMPLEMENTATIONS

  template <typename Graph, typename LengthMap, typename Heap >
  void Dijkstra<Graph,LengthMap,Heap>::run(Node s) {
    
    NodeIt u;
    for ( G.first(u) ; G.valid(u) ; G.next(u) ) {
      predecessor.set(u,INVALID);
      // If a node is unreacheable, then why should be the dist=0?
      // distance.set(u,0);
      //      reach.set(u,false);
    }
    
    //We don't need it at all.
    //     //FIXME:
    //     typename Graph::NodeMap<bool> scanned(G,false);
    //     //typename Graph::NodeMap<int> scanned(G,false);
    typename Graph::NodeMap<int> heap_map(G,-1);
    
    Heap heap(heap_map);
    
    heap.push(s,0); 
    //    reach.set(s, true);
    
      while ( !heap.empty() ) {
	
	Node v=heap.top(); 
	ValueType oldvalue=heap[v];
	heap.pop();
	distance.set(v, oldvalue);
	
	for(OutEdgeIt e(G,v); G.valid(e); G.next(e)) {
	  Node w=G.head(e); 
	  
	  switch(heap.state(w)) {
	  case Heap::PRE_HEAP:
	    //	    reach.set(w,true);
	    heap.push(w,oldvalue+length[e]); 
	    predecessor.set(w,e);
	    pred_node.set(w,v);
	    break;
	  case Heap::IN_HEAP:
	    if ( oldvalue+length[e] < heap[w] ) {
	      heap.decrease(w, oldvalue+length[e]); 
	      predecessor.set(w,e);
	      pred_node.set(w,v);
	    }
	    break;
	  case Heap::POST_HEAP:
	    break;
	  }
	}
      }
  }
  
} //END OF NAMESPACE HUGO

#endif


