/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2006
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include <algowin.h>
#include <algobox.h>
#include <kruskalbox.h>
#include <dijkstrabox.h>

sigc::signal<void, AlgoWin *> AlgoWin::signal_closing()
{
  return signal_closed;
}

sigc::signal<void, AlgoWin *, std::string> AlgoWin::signal_maplist_needed()
{
  return signal_maplist_need;
}

bool AlgoWin::closeIfEscapeIsPressed(GdkEventKey* e)
{
  if(e->keyval==GDK_Escape)
  {
    on_hide();
  }
  return true;
}

AlgoWin::AlgoWin(int algoid, std::vector<std::string> tabnames)
{
  signal_key_press_event().connect(sigc::mem_fun(*this, &AlgoWin::closeIfEscapeIsPressed));

  Gtk::VBox * vbox=new Gtk::VBox();
  vbox->set_spacing(5);

  Gtk::Label * label=new Gtk::Label("Select digraph:");

  switch(algoid)
    {
    case 0:
      ab=new AlgoBox(tabnames);
      set_title("Algo Win Demo");
      break;
    case 1:
      ab=new KruskalBox(tabnames);
      set_title("Kruskal Algorithm");
      break;
    case 2:
      ab=new DijkstraBox(tabnames);
      set_title("Dijkstra Algorithm");
      break;
    case 3:
      ab=new SuurballeBox(tabnames);
      set_title("Suurballe Algorithm");
      break;
    default:
      break;
    }
  ab->signal_maplist_needed().connect(sigc::mem_fun(*this, &AlgoWin::emit_tab_change));
  ab->signal_newmapwin_needed().connect(sigc::mem_fun(*this, &AlgoWin::emit_new_map_signal));

  runbutton=new Gtk::Button("Run");
  runbutton->signal_released().connect(sigc::mem_fun(*ab,&AlgoBox::run));
  runbutton->signal_activate().connect(sigc::mem_fun(*ab,&AlgoBox::run));

  closebutton=new Gtk::Button("Close");
  closebutton->signal_released().connect(sigc::mem_fun(*this,&AlgoWin::on_hide));
  closebutton->signal_activate().connect(sigc::mem_fun(*this,&AlgoWin::on_hide));
      
  Gtk::HBox * hbox=new Gtk::HBox();

  hbox->pack_start(*runbutton);
  hbox->pack_start(*closebutton);

  vbox->pack_start(*label);
  vbox->pack_start(*ab);
  vbox->pack_start(*hbox);
      
  add(*vbox);

  show_all_children();
};

void AlgoWin::update_tablist(std::vector<std::string> tabnames)
{
  ab->update_tablist(tabnames);
}

void AlgoWin::update_maplist(MapStorage * mapstorage)
{
  ab->update_maplist(mapstorage);
}

void AlgoWin::on_hide()
{
  signal_closed.emit(this);
  Gtk::Window::on_hide();
}

void AlgoWin::emit_tab_change(std::string newtab)
{
  signal_maplist_need.emit(this, newtab);
}
