#include <background_chooser_dialog.h>
#include <gtkmm/stock.h>
#include <mapstorage.h>

BackgroundChooserDialog::BackgroundChooserDialog(MapStorage* ms) :
  mapstorage(ms),
  btnClear(Gtk::Stock::CLEAR)
{
  set_has_separator(false);

  Gtk::VBox* pVBox = get_vbox();

  lblBackground.set_text("<b>Background image file</b>");
  lblBackground.set_use_markup();
  lblBackground.set_alignment(Gtk::ALIGN_LEFT);
  lblScaling.set_text("<b>Scaling factor</b>");
  lblScaling.set_use_markup();
  lblScaling.set_alignment(Gtk::ALIGN_LEFT);
  fcbBackground.set_width_chars(30);
  fcbBackground.set_action(Gtk::FILE_CHOOSER_ACTION_OPEN);
  if (mapstorage->isBackgroundSet())
  {
    fcbBackground.set_filename(mapstorage->getBackgroundFilename());
  }

  fcbBackground.signal_selection_changed().connect(
    sigc::mem_fun(*this, &BackgroundChooserDialog::setBackground));

  btnClear.signal_clicked().connect(
    sigc::mem_fun(*this, &BackgroundChooserDialog::clearBackground));

  pVBox->pack_start(lblBackground, Gtk::PACK_SHRINK);
  pVBox->pack_start(box, Gtk::PACK_SHRINK);
  box.pack_start(fcbBackground, Gtk::PACK_EXPAND_WIDGET);
  box.pack_start(btnClear, Gtk::PACK_SHRINK);
  pVBox->pack_start(lblScaling, Gtk::PACK_SHRINK);
  pVBox->pack_start(sbScaling, Gtk::PACK_SHRINK);

  add_button(Gtk::Stock::CLOSE, Gtk::RESPONSE_CLOSE);

  show_all_children();
}

void BackgroundChooserDialog::clearBackground()
{
  fcbBackground.unselect_all();
}

void BackgroundChooserDialog::setBackground()
{
  mapstorage->setBackground(fcbBackground.get_filename());
}
