/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2006
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include <design_win.h>

bool DesignWin::closeIfEscapeIsPressed(GdkEventKey* e)
{
  if(e->keyval==GDK_Escape)
  {
    on_hide();
  }
  return true;
}

DesignWin::DesignWin(const std::string& title, double attraction_v, double propulsation_v, int iterations_v)
{
  set_title(title);

  //mytab.signal_title_ch().connect(sigc::mem_fun(*this, &DesignWin::set_title));

  signal_key_press_event().connect(sigc::mem_fun(*this, &DesignWin::closeIfEscapeIsPressed));

  Gtk::VBox * vbox=new Gtk::VBox();
  vbox->set_spacing(5);

  Gtk::Label * attraction_label=new Gtk::Label("Arc elasticity: ");
  Gtk::Label * propulsation_label=new Gtk::Label("Node propulsation: ");
  Gtk::Label * iteration_label=new Gtk::Label("Iteration number: ");

  Gtk::Adjustment * attraction_adjustment=new Gtk::Adjustment(attraction_v, 0,1,0.01,0.1);
  Gtk::Adjustment * propulsation_adjustment=new Gtk::Adjustment(propulsation_v,0,1000000,1000,10000);
  Gtk::Adjustment * iteration_adjustment=new Gtk::Adjustment(iterations_v,1,20000,5,10);

  attraction = new Gtk::SpinButton(*attraction_adjustment,5,3);
  propulsation = new Gtk::SpinButton(*propulsation_adjustment,5,0);
  iteration = new Gtk::SpinButton(*iteration_adjustment,5,0);

  close_button=new Gtk::Button("Redesign");

  attraction->signal_value_changed().connect(sigc::mem_fun(*this, &DesignWin::emit_attraction));
  propulsation->signal_value_changed().connect(sigc::mem_fun(*this, &DesignWin::emit_propulsation));
  iteration->signal_value_changed().connect(sigc::mem_fun(*this, &DesignWin::emit_iteration));
  close_button->signal_pressed().connect(sigc::mem_fun(*this, &DesignWin::emit_closerun));

  table.attach(*attraction_label,0,1,0,1);
  table.attach(*propulsation_label,0,1,1,2);
  table.attach(*iteration_label,0,1,2,3);
  table.attach(*attraction,1,2,0,1);
  table.attach(*propulsation,1,2,1,2);
  table.attach(*iteration,1,2,2,3);
  table.attach(*close_button,0,2,3,4);

  add(table);

  show_all_children();
};

void DesignWin::emit_attraction()
{
  signal_attraction_ch.emit(attraction->get_value());
}

void DesignWin::emit_propulsation()
{
  signal_propulsation_ch.emit(propulsation->get_value());
}

void DesignWin::emit_iteration()
{
  signal_iteration_ch.emit((int)iteration->get_value());
}

void DesignWin::set_title(std::string tabname)
{
  Gtk::Window::set_title("Design Setup - "+tabname);
}

void DesignWin::set_data(double attr, double propuls, int it)
{
  attraction->set_value(attr);
  propulsation->set_value(propuls);
  iteration->set_value(it);
}
