#include "file_import_dialog.h"
#include <gtkmm/dialog.h>
#include <gtkmm/stock.h>
#include <gtkmm/notebook.h>
#include <gtkmm/messagedialog.h>
#include <gtkmm/frame.h>
#include <iostream>

FileImportDialog::FileImportDialog(ImportData* d) :
  p_data(d)
{
  add_button(Gtk::Stock::CANCEL, Gtk::RESPONSE_CANCEL);
  add_button(Gtk::Stock::OK, Gtk::RESPONSE_OK);

  Gtk::VBox* pVBox = get_vbox();

  Gtk::Notebook* nb = Gtk::manage(new Gtk::Notebook);
  pVBox->pack_start(*nb, Gtk::PACK_EXPAND_WIDGET);

  Gtk::VBox* vblueMaps = Gtk::manage(new Gtk::VBox(false, 18));
  vblueMaps->set_border_width(12);

  Gtk::VBox* vbArcMaps = Gtk::manage(new Gtk::VBox(false, 18));
  vbArcMaps->set_border_width(12);

  Gtk::VBox* vbSpecMaps = Gtk::manage(new Gtk::VBox(false, 18));
  vbSpecMaps->set_border_width(12);

  nb->append_page(*vbSpecMaps, "Special Maps");
  nb->append_page(*vblueMaps, "Node Maps");
  nb->append_page(*vbArcMaps, "Arc Maps");

  // child widgets of vbSpecMaps
  {
    Gtk::VBox* box1 = Gtk::manage(new Gtk::VBox(false, 6));
    vbSpecMaps->pack_start(*box1, Gtk::PACK_SHRINK);

    {
      Gtk::Label* label1 =
        Gtk::manage(new Gtk::Label("<b>Node Coordinates</b>"));
      label1->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
      label1->set_use_markup();
      box1->pack_start(*label1);

      Gtk::HBox* box2 = Gtk::manage(new Gtk::HBox);
      box1->pack_start(*box2);

      Gtk::Label* fill1 = Gtk::manage(new Gtk::Label("    "));
      box2->pack_start(*fill1, Gtk::PACK_SHRINK);

      Gtk::VBox* box3 = Gtk::manage(new Gtk::VBox);
      box2->pack_start(*box3);

      Gtk::VBox* box13 = Gtk::manage(new Gtk::VBox);
      box3->pack_start(*box13);

      rblueCoordNone.set_label("None");
      Gtk::RadioButtonGroup group = rblueCoordNone.get_group();
      box13->pack_start(rblueCoordNone);

      Gtk::VBox* box4 = Gtk::manage(new Gtk::VBox);
      box3->pack_start(*box4);

      rblueCoordOneMap.set_label("One Map");
      rblueCoordOneMap.set_group(group);
      box4->pack_start(rblueCoordOneMap);

      Gtk::HBox* box5 = Gtk::manage(new Gtk::HBox);
      box4->pack_start(*box5);

      Gtk::Label* fill2 = Gtk::manage(new Gtk::Label("    "));
      box5->pack_start(*fill2, Gtk::PACK_SHRINK);

      Gtk::VBox* box6 = Gtk::manage(new Gtk::VBox);
      box5->pack_start(*box6);

      Gtk::HBox* box7 = Gtk::manage(new Gtk::HBox);
      box6->pack_start(*box7);

      Gtk::Label* label2 = Gtk::manage(new Gtk::Label("(X, Y)"));
      box7->pack_start(*label2, Gtk::PACK_SHRINK, 4);

      box7->pack_start(cblueCoordOneMap, Gtk::PACK_EXPAND_WIDGET);


      Gtk::VBox* box8 = Gtk::manage(new Gtk::VBox);
      box3->pack_start(*box8);

      rblueCoordTwoMaps.set_label("Two Maps");
      rblueCoordTwoMaps.set_group(group);
      box8->pack_start(rblueCoordTwoMaps);

      Gtk::HBox* box9 = Gtk::manage(new Gtk::HBox);
      box8->pack_start(*box9);

      Gtk::Label* fill3 = Gtk::manage(new Gtk::Label("    "));
      box9->pack_start(*fill3, Gtk::PACK_SHRINK);

      Gtk::VBox* box10 = Gtk::manage(new Gtk::VBox);
      box9->pack_start(*box10);

      Gtk::HBox* box11 = Gtk::manage(new Gtk::HBox);
      box10->pack_start(*box11);

      Gtk::Label* label3 = Gtk::manage(new Gtk::Label("X"));
      box11->pack_start(*label3, Gtk::PACK_SHRINK, 4);

      box11->pack_start(cblueCoordTwoMaps1, Gtk::PACK_EXPAND_WIDGET);

      Gtk::HBox* box12 = Gtk::manage(new Gtk::HBox);
      box10->pack_start(*box12);

      Gtk::Label* label4 = Gtk::manage(new Gtk::Label("Y"));
      box12->pack_start(*label4, Gtk::PACK_SHRINK, 4);

      box12->pack_start(cblueCoordTwoMaps2, Gtk::PACK_EXPAND_WIDGET);

      cblueCoordOneMap.signal_changed().connect(
          sigc::mem_fun(*this, &FileImportDialog::onNodeCoordOneMapChanged));
      cblueCoordTwoMaps1.signal_changed().connect(
          sigc::mem_fun(*this, &FileImportDialog::onNodeCoordTwoMaps1Changed));
      cblueCoordTwoMaps2.signal_changed().connect(
          sigc::mem_fun(*this, &FileImportDialog::onNodeCoordTwoMaps2Changed));
    }

    {
      Gtk::Label* label1 =
        Gtk::manage(new Gtk::Label("<b>Arrow Coordinates</b>"));
      label1->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
      label1->set_use_markup();
      box1->pack_start(*label1);

      Gtk::HBox* box2 = Gtk::manage(new Gtk::HBox);
      box1->pack_start(*box2);

      Gtk::Label* fill1 = Gtk::manage(new Gtk::Label("    "));
      box2->pack_start(*fill1, Gtk::PACK_SHRINK);

      Gtk::VBox* box3 = Gtk::manage(new Gtk::VBox);
      box2->pack_start(*box3);

      Gtk::VBox* box13 = Gtk::manage(new Gtk::VBox);
      box3->pack_start(*box13);

      rbArrowCoordNone.set_label("None");
      Gtk::RadioButtonGroup group = rbArrowCoordNone.get_group();
      box13->pack_start(rbArrowCoordNone);

      Gtk::VBox* box4 = Gtk::manage(new Gtk::VBox);
      box3->pack_start(*box4);

      rbArrowCoordOneMap.set_label("One Map");
      rbArrowCoordOneMap.set_group(group);
      box4->pack_start(rbArrowCoordOneMap);

      Gtk::HBox* box5 = Gtk::manage(new Gtk::HBox);
      box4->pack_start(*box5);

      Gtk::Label* fill2 = Gtk::manage(new Gtk::Label("    "));
      box5->pack_start(*fill2, Gtk::PACK_SHRINK);

      Gtk::VBox* box6 = Gtk::manage(new Gtk::VBox);
      box5->pack_start(*box6);

      Gtk::HBox* box7 = Gtk::manage(new Gtk::HBox);
      box6->pack_start(*box7);

      Gtk::Label* label2 = Gtk::manage(new Gtk::Label("(X, Y)"));
      box7->pack_start(*label2, Gtk::PACK_SHRINK, 4);

      box7->pack_start(cbArrowCoordOneMap, Gtk::PACK_EXPAND_WIDGET);


      Gtk::VBox* box8 = Gtk::manage(new Gtk::VBox);
      box3->pack_start(*box8);

      rbArrowCoordTwoMaps.set_label("Two Maps");
      rbArrowCoordTwoMaps.set_group(group);
      box8->pack_start(rbArrowCoordTwoMaps);

      Gtk::HBox* box9 = Gtk::manage(new Gtk::HBox);
      box8->pack_start(*box9);

      Gtk::Label* fill3 = Gtk::manage(new Gtk::Label("    "));
      box9->pack_start(*fill3, Gtk::PACK_SHRINK);

      Gtk::VBox* box10 = Gtk::manage(new Gtk::VBox);
      box9->pack_start(*box10);

      Gtk::HBox* box11 = Gtk::manage(new Gtk::HBox);
      box10->pack_start(*box11);

      Gtk::Label* label3 = Gtk::manage(new Gtk::Label("X"));
      box11->pack_start(*label3, Gtk::PACK_SHRINK, 4);

      box11->pack_start(cbArrowCoordTwoMaps1, Gtk::PACK_EXPAND_WIDGET);

      Gtk::HBox* box12 = Gtk::manage(new Gtk::HBox);
      box10->pack_start(*box12);

      Gtk::Label* label4 = Gtk::manage(new Gtk::Label("Y"));
      box12->pack_start(*label4, Gtk::PACK_SHRINK, 4);

      box12->pack_start(cbArrowCoordTwoMaps2, Gtk::PACK_EXPAND_WIDGET);

      cbArrowCoordOneMap.signal_changed().connect(
          sigc::mem_fun(*this, &FileImportDialog::onArrowCoordOneMapChanged));
      cbArrowCoordTwoMaps1.signal_changed().connect(
          sigc::mem_fun(*this, &FileImportDialog::onArrowCoordTwoMaps1Changed));
      cbArrowCoordTwoMaps2.signal_changed().connect(
          sigc::mem_fun(*this, &FileImportDialog::onArrowCoordTwoMaps2Changed));
    }
  }

  // child widgets of vblueMaps
  {
    Gtk::VBox* box1 = Gtk::manage(new Gtk::VBox(false, 6));
    vblueMaps->pack_start(*box1, Gtk::PACK_SHRINK);

    Gtk::Label* label1 =
      Gtk::manage(new Gtk::Label("<b>Element type</b>"));
    label1->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
    label1->set_use_markup();
    box1->pack_start(*label1, Gtk::PACK_SHRINK);

    Gtk::HBox* box2 = Gtk::manage(new Gtk::HBox);
    box1->pack_start(*box2, Gtk::PACK_SHRINK);

    Gtk::Label* fill1 = Gtk::manage(new Gtk::Label("    "));
    box2->pack_start(*fill1, Gtk::PACK_SHRINK);

    Gtk::Frame* frame = Gtk::manage(new Gtk::Frame);
    box2->pack_start(*frame, Gtk::PACK_EXPAND_WIDGET);

    Gtk::ScrolledWindow* swNodeMaps = Gtk::manage(new Gtk::ScrolledWindow);
    frame->add(*swNodeMaps);

    swNodeMaps->add(twNodeMaps);

    refNodeMapStore = Gtk::ListStore::create(NodeMapColumns);

    for (std::vector<std::string>::const_iterator it =
        p_data->node_map_names.begin(); it != p_data->node_map_names.end();
        ++it)
    {
      node_tree_view_records.push_back(
          tree_view_record(*it, false, false, true));
    }

    twNodeMaps.set_model(refNodeMapStore);
    twNodeMaps.append_column("Name", NodeMapColumns.colName);
    {
      int col = twNodeMaps.append_column_editable("Numeric",
          NodeMapColumns.colReadAsNumeric);
      Gtk::CellRendererToggle* pRenderer =
        static_cast<Gtk::CellRendererToggle*>(
            twNodeMaps.get_column_cell_renderer(col-1));
      pRenderer->signal_toggled().connect(
          sigc::mem_fun(*this, &FileImportDialog::onNodeMapNumericToggled));
    }
    {
      int col = twNodeMaps.append_column_editable("String",
          NodeMapColumns.colReadAsString);
      Gtk::CellRendererToggle* pRenderer =
        static_cast<Gtk::CellRendererToggle*>(
            twNodeMaps.get_column_cell_renderer(col-1));
      pRenderer->signal_toggled().connect(
          sigc::mem_fun(*this, &FileImportDialog::onNodeMapStringToggled));
    }

    swNodeMaps->set_size_request(-1, 200);
    swNodeMaps->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
  }

  // child widgets of vbArcMaps
  {
    Gtk::VBox* box1 = Gtk::manage(new Gtk::VBox(false, 6));
    vbArcMaps->pack_start(*box1, Gtk::PACK_SHRINK);

    Gtk::Label* label1 =
      Gtk::manage(new Gtk::Label("<b>Element type</b>"));
    label1->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
    label1->set_use_markup();
    box1->pack_start(*label1, Gtk::PACK_SHRINK);

    Gtk::HBox* box2 = Gtk::manage(new Gtk::HBox);
    box1->pack_start(*box2, Gtk::PACK_SHRINK);

    Gtk::Label* fill1 = Gtk::manage(new Gtk::Label("    "));
    box2->pack_start(*fill1, Gtk::PACK_SHRINK);

    Gtk::Frame* frame = Gtk::manage(new Gtk::Frame);
    box2->pack_start(*frame, Gtk::PACK_EXPAND_WIDGET);

    Gtk::ScrolledWindow* swArcMaps = Gtk::manage(new Gtk::ScrolledWindow);
    frame->add(*swArcMaps);

    swArcMaps->add(twArcMaps);

    refArcMapStore = Gtk::ListStore::create(ArcMapColumns);

    for (std::vector<std::string>::const_iterator it =
        p_data->arc_map_names.begin(); it != p_data->arc_map_names.end();
        ++it)
    {
      arc_tree_view_records.push_back(
          tree_view_record(*it, false, false, true));
    }

    twArcMaps.set_model(refArcMapStore);
    twArcMaps.append_column("Name", ArcMapColumns.colName);
    {
      int col = twArcMaps.append_column_editable("Numeric",
          ArcMapColumns.colReadAsNumeric);
      Gtk::CellRendererToggle* pRenderer =
        static_cast<Gtk::CellRendererToggle*>(
            twArcMaps.get_column_cell_renderer(col-1));
      pRenderer->signal_toggled().connect(
          sigc::mem_fun(*this, &FileImportDialog::onArcMapNumericToggled));
    }
    {
      int col = twArcMaps.append_column_editable("String",
          ArcMapColumns.colReadAsString);
      Gtk::CellRendererToggle* pRenderer =
        static_cast<Gtk::CellRendererToggle*>(
            twArcMaps.get_column_cell_renderer(col-1));
      pRenderer->signal_toggled().connect(
          sigc::mem_fun(*this, &FileImportDialog::onArcMapStringToggled));
    }

    swArcMaps->set_size_request(-1, 200);
    swArcMaps->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
  }

  // fill in the ComboBoxes
  typedef std::vector<std::string> StrVec;
  for (StrVec::const_iterator it = p_data->node_map_names.begin();
      it != p_data->node_map_names.end(); ++it)
  {
    cblueCoordTwoMaps1.append_text(*it);
    cblueCoordTwoMaps2.append_text(*it);
  }
  for (StrVec::const_iterator it = p_data->arc_map_names.begin();
      it != p_data->arc_map_names.end(); ++it)
  {
    cbArrowCoordTwoMaps1.append_text(*it);
    cbArrowCoordTwoMaps2.append_text(*it);
  }
  for (StrVec::const_iterator it = p_data->xy_node_map_names.begin();
      it != p_data->xy_node_map_names.end(); ++it)
  {
    cblueCoordOneMap.append_text(*it);
  }
  for (StrVec::const_iterator it = p_data->xy_arc_map_names.begin();
      it != p_data->xy_arc_map_names.end(); ++it)
  {
    cbArrowCoordOneMap.append_text(*it);
  }

  if (p_data->isXYNodeMap("coord"))
  {
    cblueCoordOneMap.set_active_text("coord");
  }
  else if (p_data->isXYNodeMap("coords"))
  {
    cblueCoordOneMap.set_active_text("coords");
  }
  else if (p_data->isNodeMap("coord_x") &&
           p_data->isNodeMap("coord_y"))
  {
    cblueCoordTwoMaps1.set_active_text("coord_x");
    cblueCoordTwoMaps2.set_active_text("coord_y");
  }
  else if (p_data->isNodeMap("coords_x") &&
           p_data->isNodeMap("coords_y"))
  {
    cblueCoordTwoMaps1.set_active_text("coords_x");
    cblueCoordTwoMaps2.set_active_text("coords_y");
  }
  else if (p_data->isNodeMap("x") &&
           p_data->isNodeMap("y"))
  {
    cblueCoordTwoMaps1.set_active_text("x");
    cblueCoordTwoMaps2.set_active_text("y");
  }

  if (p_data->isXYArcMap("arrow"))
  {
    cbArrowCoordOneMap.set_active_text("arrow");
  }
  else if (p_data->isXYArcMap("arrows"))
  {
    cbArrowCoordOneMap.set_active_text("arrows");
  }
  else if (p_data->isXYArcMap("midpoint"))
  {
    cbArrowCoordOneMap.set_active_text("midpoint");
  }
  else if (p_data->isXYArcMap("midpoints"))
  {
    cbArrowCoordOneMap.set_active_text("midpoints");
  }
  else if (p_data->isXYArcMap("mid"))
  {
    cbArrowCoordOneMap.set_active_text("mid");
  }
  else if (p_data->isXYArcMap("mids"))
  {
    cbArrowCoordOneMap.set_active_text("mids");
  }
  else if (p_data->isArcMap("arrow_x") &&
           p_data->isArcMap("arrow_y"))
  {
    cbArrowCoordTwoMaps1.set_active_text("arrow_x");
    cbArrowCoordTwoMaps2.set_active_text("arrow_y");
  }
  else if (p_data->isArcMap("arrows_x") &&
           p_data->isArcMap("arrows_y"))
  {
    cbArrowCoordTwoMaps1.set_active_text("arrows_x");
    cbArrowCoordTwoMaps2.set_active_text("arrows_y");
  }
  else if (p_data->isArcMap("midpoint_x") &&
           p_data->isArcMap("midpoint_y"))
  {
    cbArrowCoordTwoMaps1.set_active_text("midpoint_x");
    cbArrowCoordTwoMaps2.set_active_text("midpoint_y");
  }
  else if (p_data->isArcMap("midpoints_x") &&
           p_data->isArcMap("midpoints_y"))
  {
    cbArrowCoordTwoMaps1.set_active_text("midpoints_x");
    cbArrowCoordTwoMaps2.set_active_text("midpoints_y");
  }
  else if (p_data->isArcMap("mid_x") &&
           p_data->isArcMap("mid_y"))
  {
    cbArrowCoordTwoMaps1.set_active_text("mid_x");
    cbArrowCoordTwoMaps2.set_active_text("mid_y");
  }
  else if (p_data->isArcMap("mids_x") &&
           p_data->isArcMap("mids_y"))
  {
    cbArrowCoordTwoMaps1.set_active_text("mids_x");
    cbArrowCoordTwoMaps2.set_active_text("mids_y");
  }

  {
    if (cblueCoordOneMap.get_active_text() != "")
      rblueCoordOneMap.set_active();
    else if (cblueCoordTwoMaps1.get_active_text() != "")
      rblueCoordTwoMaps.set_active();
    else
      rblueCoordNone.set_active();

    if (cbArrowCoordOneMap.get_active_text() != "")
      rbArrowCoordOneMap.set_active();
    else if (cbArrowCoordTwoMaps1.get_active_text() != "")
      rbArrowCoordTwoMaps.set_active();
    else
      rbArrowCoordNone.set_active();

    onNodeCoordMapNumToggled();
    onArrowCoordMapNumToggled();

    rblueCoordOneMap.signal_toggled().connect(
        sigc::mem_fun(*this, &FileImportDialog::onNodeCoordMapNumToggled));
    rblueCoordTwoMaps.signal_toggled().connect(
        sigc::mem_fun(*this, &FileImportDialog::onNodeCoordMapNumToggled));
    rbArrowCoordOneMap.signal_toggled().connect(
        sigc::mem_fun(*this, &FileImportDialog::onArrowCoordMapNumToggled));
    rbArrowCoordTwoMaps.signal_toggled().connect(
        sigc::mem_fun(*this, &FileImportDialog::onArrowCoordMapNumToggled));
  }

  signal_response().connect(
      sigc::mem_fun(*this, &FileImportDialog::onResponse));

  update_node_tree_view();
  update_arc_tree_view();

  show_all_children();
}

void FileImportDialog::onNodeCoordMapNumToggled()
{
  if (rblueCoordOneMap.get_active())
  {
    cblueCoordOneMap.get_parent()->set_sensitive(true);
    cblueCoordTwoMaps1.get_parent()->set_sensitive(false);
    cblueCoordTwoMaps2.get_parent()->set_sensitive(false);

    p_data->node_coord_load_from = ImportData::ONE_MAP;
  }
  else if (rblueCoordTwoMaps.get_active())
  {
    cblueCoordOneMap.get_parent()->set_sensitive(false);
    cblueCoordTwoMaps1.get_parent()->set_sensitive(true);
    cblueCoordTwoMaps2.get_parent()->set_sensitive(true);

    p_data->node_coord_load_from = ImportData::TWO_MAPS;
  }
  else if (rblueCoordNone.get_active())
  {
    cblueCoordOneMap.get_parent()->set_sensitive(false);
    cblueCoordTwoMaps1.get_parent()->set_sensitive(false);
    cblueCoordTwoMaps2.get_parent()->set_sensitive(false);

    p_data->node_coord_load_from = ImportData::DONT_READ;
  }
  update_node_tree_view();
}

void FileImportDialog::onArrowCoordMapNumToggled()
{
  if (rbArrowCoordOneMap.get_active())
  {
    cbArrowCoordOneMap.get_parent()->set_sensitive(true);
    cbArrowCoordTwoMaps1.get_parent()->set_sensitive(false);
    cbArrowCoordTwoMaps2.get_parent()->set_sensitive(false);

    p_data->arrow_coord_load_from = ImportData::ONE_MAP;
  }
  else if (rbArrowCoordTwoMaps.get_active())
  {
    cbArrowCoordOneMap.get_parent()->set_sensitive(false);
    cbArrowCoordTwoMaps1.get_parent()->set_sensitive(true);
    cbArrowCoordTwoMaps2.get_parent()->set_sensitive(true);

    p_data->arrow_coord_load_from = ImportData::TWO_MAPS;
  }
  else if (rbArrowCoordNone.get_active())
  {
    cbArrowCoordOneMap.get_parent()->set_sensitive(false);
    cbArrowCoordTwoMaps1.get_parent()->set_sensitive(false);
    cbArrowCoordTwoMaps2.get_parent()->set_sensitive(false);

    p_data->arrow_coord_load_from = ImportData::DONT_READ;
  }
  update_arc_tree_view();
}

FileImportDialog::~FileImportDialog()
{
}

void FileImportDialog::onResponse(int id)
{
  if (id == Gtk::RESPONSE_OK)
  {
    if ((rblueCoordOneMap.get_active() &&
          cblueCoordOneMap.get_active_text() == "") ||
        (rblueCoordTwoMaps.get_active() &&
         (cblueCoordTwoMaps1.get_active_text() == "" ||
          cblueCoordTwoMaps2.get_active_text() == "")))
    {
      Gtk::MessageDialog mdialog("No node map selected.",
          false, Gtk::MESSAGE_ERROR);
      mdialog.run();
      return;
    }
    else if (rblueCoordTwoMaps.get_active() &&
             cblueCoordTwoMaps1.get_active_text() == 
             cblueCoordTwoMaps2.get_active_text())
    {
      Gtk::MessageDialog mdialog(
          "Same node map selected for both coordinates.",
          false, Gtk::MESSAGE_ERROR);
      mdialog.run();
      return;
    }
    if ((rbArrowCoordOneMap.get_active() &&
          cbArrowCoordOneMap.get_active_text() == "") ||
        (rbArrowCoordTwoMaps.get_active() &&
         (cbArrowCoordTwoMaps1.get_active_text() == "" ||
          cbArrowCoordTwoMaps2.get_active_text() == "")))
    {
      Gtk::MessageDialog mdialog("No arc map selected.",
          false, Gtk::MESSAGE_ERROR);
      mdialog.run();
      return;
    }
    else if (rbArrowCoordTwoMaps.get_active() &&
             cbArrowCoordTwoMaps1.get_active_text() == 
             cbArrowCoordTwoMaps2.get_active_text())
    {
      Gtk::MessageDialog mdialog(
          "Same arc map selected for both coordinates.",
          false, Gtk::MESSAGE_ERROR);
      mdialog.run();
      return;
    }

    for (std::vector<tree_view_record>::const_iterator it =
        node_tree_view_records.begin(); it != node_tree_view_records.end();
        ++it)
    {
      if (it->visible)
      {
        if (it->numeric)
          p_data->numeric_node_map_names.push_back(it->name);
        if (it->string)
          p_data->string_node_map_names.push_back(it->name);
      }
    }

    for (std::vector<tree_view_record>::const_iterator it =
        arc_tree_view_records.begin(); it != arc_tree_view_records.end();
        ++it)
    {
      if (it->visible)
      {
        if (it->numeric)
          p_data->numeric_arc_map_names.push_back(it->name);
        if (it->string)
          p_data->string_arc_map_names.push_back(it->name);
      }
    }
  }
}

FileImportDialog::ImportData::ImportData(
    const std::vector<std::string>& _node_map_names,
    const std::vector<std::string>& _arc_map_names) :
  node_map_names(_node_map_names),
  arc_map_names(_arc_map_names)
{
  typedef std::vector<std::string> StrVec;
  {
    StrVec xMaps;
    StrVec yMaps;
    // collect map names ending with ":x" and ":y"
    for (StrVec::const_iterator it = node_map_names.begin();
        it != node_map_names.end(); ++it)
    {
      if ((it->length() >= 3) &&
          (it->substr(it->length()-2, it->length())  == ":x"))
      {
        xMaps.push_back(it->substr(0, it->length()-2));
      }
      if ((it->length() >= 3) &&
          (it->substr(it->length()-2, it->length())  == ":y"))
      {
        yMaps.push_back(it->substr(0, it->length()-2));
      }
    }

    for (StrVec::const_iterator it1 = xMaps.begin();
        it1 != xMaps.end(); ++it1)
    {
      for (StrVec::const_iterator it2 = yMaps.begin();
          it2 != yMaps.end(); ++it2)
      {
        if (*it1 == *it2) xy_node_map_names.push_back(*it1);
      }
    }
  }
  {
    StrVec xMaps;
    StrVec yMaps;
    // collect map names ending with ":x" and ":y"
    for (StrVec::const_iterator it = arc_map_names.begin();
        it != arc_map_names.end(); ++it)
    {
      if ((it->length() >= 3) &&
          (it->substr(it->length()-2, it->length())  == ":x"))
      {
        xMaps.push_back(it->substr(0, it->length()-2));
      }
      if ((it->length() >= 3) &&
          (it->substr(it->length()-2, it->length())  == ":y"))
      {
        yMaps.push_back(it->substr(0, it->length()-2));
      }
    }

    for (StrVec::const_iterator it1 = xMaps.begin();
        it1 != xMaps.end(); ++it1)
    {
      for (StrVec::const_iterator it2 = yMaps.begin();
          it2 != yMaps.end(); ++it2)
      {
        if (*it1 == *it2) xy_arc_map_names.push_back(*it1);
      }
    }
  }
}

FileImportDialog::ImportData::~ImportData()
{
}

bool FileImportDialog::ImportData::isXYNodeMap(const std::string& name)
{
  if (isNodeMap(name + ":x") && isNodeMap(name + ":y")) return true;
  return false;
}

bool FileImportDialog::ImportData::isXYArcMap(const std::string& name)
{
  if (isArcMap(name + ":x") && isArcMap(name + ":y")) return true;
  return false;
}

bool FileImportDialog::ImportData::isNodeMap(const std::string& name)
{
  if (contains(node_map_names, name)) return true;
  return false;
}

bool FileImportDialog::ImportData::isArcMap(const std::string& name)
{
  if (contains(arc_map_names, name)) return true;
  return false;
}

bool FileImportDialog::ImportData::contains(const std::vector<std::string>& vec,
    const std::string& str)
{
  for (std::vector<std::string>::const_iterator it = vec.begin();
      it != vec.end(); ++it)
  {
    if (*it == str) return true;
  }
  return false;
}

void FileImportDialog::onNodeCoordOneMapChanged()
{
  p_data->node_coord_one_map_name = cblueCoordOneMap.get_active_text();
  update_node_tree_view();
}

void FileImportDialog::onNodeCoordTwoMaps1Changed()
{
  p_data->node_coord_two_maps_1_name = cblueCoordTwoMaps1.get_active_text();
  update_node_tree_view();
}

void FileImportDialog::onNodeCoordTwoMaps2Changed()
{
  p_data->node_coord_two_maps_2_name = cblueCoordTwoMaps2.get_active_text();
  update_node_tree_view();
}

void FileImportDialog::onArrowCoordOneMapChanged()
{
  p_data->arrow_coord_one_map_name = cbArrowCoordOneMap.get_active_text();
  update_arc_tree_view();
}

void FileImportDialog::onArrowCoordTwoMaps1Changed()
{
  p_data->arrow_coord_two_maps_1_name = cbArrowCoordTwoMaps1.get_active_text();
  update_arc_tree_view();
}

void FileImportDialog::onArrowCoordTwoMaps2Changed()
{
  p_data->arrow_coord_two_maps_2_name = cbArrowCoordTwoMaps2.get_active_text();
  update_arc_tree_view();
}

void FileImportDialog::onNodeMapNumericToggled(const Glib::ustring& path)
{
  Gtk::TreeModel::iterator iter = refNodeMapStore->get_iter(
      Gtk::TreeModel::Path(path));
  Gtk::TreeModel::Row row = *iter;
  std::vector<tree_view_record>::iterator it;
  for (it = node_tree_view_records.begin();
      it != node_tree_view_records.end(); ++it)
  {
    if (it->name == row[NodeMapColumns.colName]) break;
  }
  if (row[NodeMapColumns.colReadAsNumeric])
  {
    row[NodeMapColumns.colReadAsString] = false;
    it->string = false;
    it->numeric = true;
  }
}

void FileImportDialog::onNodeMapStringToggled(const Glib::ustring& path)
{
  Gtk::TreeModel::iterator iter = refNodeMapStore->get_iter(
      Gtk::TreeModel::Path(path));
  Gtk::TreeModel::Row row = *iter;
  std::vector<tree_view_record>::iterator it;
  for (it = node_tree_view_records.begin();
      it != node_tree_view_records.end(); ++it)
  {
    if (it->name == row[NodeMapColumns.colName]) break;
  }
  if (row[NodeMapColumns.colReadAsString])
  {
    row[NodeMapColumns.colReadAsNumeric] = false;
    it->string = true;
    it->numeric = false;
  }
}

void FileImportDialog::update_node_tree_view()
{
  for (std::vector<tree_view_record>::iterator it =
      node_tree_view_records.begin(); it != node_tree_view_records.end(); ++it)
  {
    it->visible = true;
  }
  switch (p_data->node_coord_load_from)
  {
    case ImportData::ONE_MAP:
      for (std::vector<tree_view_record>::iterator it =
          node_tree_view_records.begin(); it !=
          node_tree_view_records.end(); ++it)
      {
        if (it->name == p_data->node_coord_one_map_name)
          it->visible = false;
      }
      break;
    case ImportData::TWO_MAPS:
      for (std::vector<tree_view_record>::iterator it =
          node_tree_view_records.begin(); it !=
          node_tree_view_records.end(); ++it)
      {
        if ((it->name == p_data->node_coord_two_maps_1_name) ||
            (it->name == p_data->node_coord_two_maps_2_name))
          it->visible = false;
      }
      break;
    case ImportData::DONT_READ:
      break;
  }
  refNodeMapStore->clear();
  for (std::vector<tree_view_record>::iterator it =
      node_tree_view_records.begin(); it != node_tree_view_records.end(); ++it)
  {
    if (it->visible)
    {
      Gtk::TreeModel::Row row = *(refNodeMapStore->append());
      row[NodeMapColumns.colName] = it->name;
      row[NodeMapColumns.colReadAsNumeric] = it->numeric;
      row[NodeMapColumns.colReadAsString] = it->string;
    }
  }
}

void FileImportDialog::onArcMapNumericToggled(const Glib::ustring& path)
{
  Gtk::TreeModel::iterator iter = refArcMapStore->get_iter(
      Gtk::TreeModel::Path(path));
  Gtk::TreeModel::Row row = *iter;
  std::vector<tree_view_record>::iterator it;
  for (it = arc_tree_view_records.begin();
      it != arc_tree_view_records.end(); ++it)
  {
    if (it->name == row[ArcMapColumns.colName]) break;
  }
  if (row[ArcMapColumns.colReadAsNumeric])
  {
    row[ArcMapColumns.colReadAsString] = false;
    it->string = false;
    it->numeric = true;
  }
}

void FileImportDialog::onArcMapStringToggled(const Glib::ustring& path)
{
  Gtk::TreeModel::iterator iter = refArcMapStore->get_iter(
      Gtk::TreeModel::Path(path));
  Gtk::TreeModel::Row row = *iter;
  std::vector<tree_view_record>::iterator it;
  for (it = arc_tree_view_records.begin();
      it != arc_tree_view_records.end(); ++it)
  {
    if (it->name == row[ArcMapColumns.colName]) break;
  }
  if (row[ArcMapColumns.colReadAsString])
  {
    row[ArcMapColumns.colReadAsNumeric] = false;
    it->string = true;
    it->numeric = false;
  }
}

void FileImportDialog::update_arc_tree_view()
{
  for (std::vector<tree_view_record>::iterator it =
      arc_tree_view_records.begin(); it != arc_tree_view_records.end(); ++it)
  {
    it->visible = true;
  }
  switch (p_data->arrow_coord_load_from)
  {
    case ImportData::ONE_MAP:
      for (std::vector<tree_view_record>::iterator it =
          arc_tree_view_records.begin(); it !=
          arc_tree_view_records.end(); ++it)
      {
        if (it->name == p_data->arrow_coord_one_map_name)
          it->visible = false;
      }
      break;
    case ImportData::TWO_MAPS:
      for (std::vector<tree_view_record>::iterator it =
          arc_tree_view_records.begin(); it !=
          arc_tree_view_records.end(); ++it)
      {
        if ((it->name == p_data->arrow_coord_two_maps_1_name) ||
            (it->name == p_data->arrow_coord_two_maps_2_name))
          it->visible = false;
      }
      break;
    case ImportData::DONT_READ:
      break;
  }
  refArcMapStore->clear();
  for (std::vector<tree_view_record>::iterator it =
      arc_tree_view_records.begin(); it != arc_tree_view_records.end(); ++it)
  {
    if (it->visible)
    {
      Gtk::TreeModel::Row row = *(refArcMapStore->append());
      row[ArcMapColumns.colName] = it->name;
      row[ArcMapColumns.colReadAsNumeric] = it->numeric;
      row[ArcMapColumns.colReadAsString] = it->string;
    }
  }
}
