#ifndef FILE_IMPORT_DIALOG
#define FILE_IMPORT_DIALOG

#include <gtkmm/dialog.h>
#include <gtkmm/radiobutton.h>
#include <gtkmm/comboboxtext.h>
#include <gtkmm/sizegroup.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/liststore.h>
#include <gtkmm/treeview.h>
#include <gtkmm/scrolledwindow.h>

class FileImportDialog : public Gtk::Dialog
{
  public:
    struct ImportData
    {
        ImportData(
            const std::vector<std::string>& _node_map_names,
            const std::vector<std::string>& _arc_map_names);

        ~ImportData();

        std::vector<std::string> node_map_names;
        std::vector<std::string> arc_map_names;

        std::vector<std::string> xy_node_map_names;
        std::vector<std::string> xy_arc_map_names;

        bool contains(
            const std::vector<std::string>& vec,
            const std::string& str);

        std::string node_coord_one_map_name;
        std::string node_coord_two_maps_1_name;
        std::string node_coord_two_maps_2_name;
        std::string arrow_coord_one_map_name;
        std::string arrow_coord_two_maps_1_name;
        std::string arrow_coord_two_maps_2_name;

        enum ReadOpts { ONE_MAP, TWO_MAPS, DONT_READ };
        ReadOpts node_coord_load_from;
        ReadOpts arrow_coord_load_from;

        bool isXYNodeMap(const std::string& name);
        bool isXYArcMap(const std::string& name);
        bool isNodeMap(const std::string& name);
        bool isArcMap(const std::string& name);

        std::vector<std::string> numeric_node_map_names;
        std::vector<std::string> string_node_map_names;
        std::vector<std::string> numeric_arc_map_names;
        std::vector<std::string> string_arc_map_names;
    };

    ImportData* p_data;

    Gtk::RadioButton rblueCoordNone;
    Gtk::RadioButton rblueCoordOneMap;
    Gtk::RadioButton rblueCoordTwoMaps;

    Gtk::RadioButton rbArrowCoordNone;
    Gtk::RadioButton rbArrowCoordOneMap;
    Gtk::RadioButton rbArrowCoordTwoMaps;

    Gtk::ComboBoxText cblueCoordOneMap;
    Gtk::ComboBoxText cblueCoordTwoMaps1;
    Gtk::ComboBoxText cblueCoordTwoMaps2;

    Gtk::ComboBoxText cbArrowCoordOneMap;
    Gtk::ComboBoxText cbArrowCoordTwoMaps1;
    Gtk::ComboBoxText cbArrowCoordTwoMaps2;

    void onNodeCoordMapNumToggled();
    void onArrowCoordMapNumToggled();

    void onResponse(int id);

    void onNodeCoordOneMapChanged();
    void onNodeCoordTwoMaps1Changed();
    void onNodeCoordTwoMaps2Changed();

    void onArrowCoordOneMapChanged();
    void onArrowCoordTwoMaps1Changed();
    void onArrowCoordTwoMaps2Changed();

    struct MapModelColumns : public Gtk::TreeModel::ColumnRecord
    {
      MapModelColumns()
      {
        add(colName);
        add(colReadAsNumeric);
        add(colReadAsString);
      }
      Gtk::TreeModelColumn<Glib::ustring> colName;
      Gtk::TreeModelColumn<bool> colReadAsNumeric;
      Gtk::TreeModelColumn<bool> colReadAsString;
    };

    Gtk::TreeView twNodeMaps;
    MapModelColumns NodeMapColumns;
    Glib::RefPtr<Gtk::ListStore> refNodeMapStore;
    void onNodeMapNumericToggled(const Glib::ustring& path);
    void onNodeMapStringToggled(const Glib::ustring& path);

    Gtk::TreeView twArcMaps;
    MapModelColumns ArcMapColumns;
    Glib::RefPtr<Gtk::ListStore> refArcMapStore;
    void onArcMapNumericToggled(const Glib::ustring& path);
    void onArcMapStringToggled(const Glib::ustring& path);

    struct tree_view_record
    {
      tree_view_record(const std::string& _name, bool _numeric, bool _string,
          bool _visible) :
        name(_name),
        numeric(_numeric),
        string(_string),
        visible(_visible) {}
      std::string name;
      bool numeric;
      bool string;
      bool visible;
    };

    std::vector<tree_view_record> node_tree_view_records;
    void update_node_tree_view();

    std::vector<tree_view_record> arc_tree_view_records;
    void update_arc_tree_view();

  public:
    FileImportDialog(ImportData* d);
    ~FileImportDialog();
};

#endif
