/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2006
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include <graph_displayer_canvas.h>
#include <mapstorage.h>
#include <nbtab.h>
#include <cmath>

const int minimum_node_radius=5;

int DigraphDisplayerCanvas::changeNodeRadius (std::string mapname, Node node)
{
  MapStorage& ms = *mytab.mapstorage;

  double min, max;

  {
    NodeIt n(ms.digraph);
    min = max = ms.get(mapname, n);
    for (; n != INVALID; ++n)
    {
      if (static_cast<double>(ms.get(mapname, n)) > max)
        max = ms.get(mapname, n);
      if (static_cast<double>(ms.get(mapname, n)) < min)
        min = ms.get(mapname, n);
    }
  }

  if(node==INVALID)
    {
      for (NodeIt i(ms.digraph); i!=INVALID; ++i)
	{
	  double v=fabs(ms.get(mapname,i));
	  int w;
	  if(autoscale)
	    {
	      if(min==max)
		{
		  w=(int)(node_property_defaults[N_RADIUS]);
		}
	      else
		{
		  w=(int)(minimum_node_radius+(v-min)/(max-min)*(radius_size-minimum_node_radius));
		}
	    }
	  else
	    {
	      w=(int)(v*radius_size);
	    }

	  if(w<minimum_node_radius)
	    {
	      w=minimum_node_radius;
	    }

	  if(zoomtrack)
	    {
	      double actual_ppu=get_pixels_per_unit();
	      w=(int)(w/actual_ppu*fixed_zoom_factor);
	    }

	  if(w>=0)
	    {
	      double x1, y1, x2, y2;
	      x1=nodesmap[i]->property_x1().get_value();
	      x2=nodesmap[i]->property_x2().get_value();
	      y1=nodesmap[i]->property_y1().get_value();
	      y2=nodesmap[i]->property_y2().get_value();
	      nodesmap[i]->property_x1().set_value((x1+x2)/2-w);
	      nodesmap[i]->property_x2().set_value((x1+x2)/2+w);
	      nodesmap[i]->property_y1().set_value((y1+y2)/2-w);
	      nodesmap[i]->property_y2().set_value((y1+y2)/2+w);
	    }
	}
    }
  else
    {
      //I think only new nodes use this case
      //that has no own value, only the default one
      //int w=(int)(*actual_map)[node];
      int w=(int)(node_property_defaults[N_RADIUS]);
      if(w>=0)
	{
	  double x1, y1, x2, y2;
	  x1=nodesmap[node]->property_x1().get_value();
	  x2=nodesmap[node]->property_x2().get_value();
	  y1=nodesmap[node]->property_y1().get_value();
	  y2=nodesmap[node]->property_y2().get_value();
	  nodesmap[node]->property_x1().set_value((x1+x2)/2-w);
	  nodesmap[node]->property_x2().set_value((x1+x2)/2+w);
	  nodesmap[node]->property_y1().set_value((y1+y2)/2-w);
	  nodesmap[node]->property_y2().set_value((y1+y2)/2+w);
	}
    }
  return 0;
};

int DigraphDisplayerCanvas::resetNodeRadius (Node node)
{
  MapStorage& ms = *mytab.mapstorage;

  double min, max;
  min=node_property_defaults[N_RADIUS];
  max=node_property_defaults[N_RADIUS];
  Digraph::NodeMap<double> actual_map(ms.digraph,node_property_defaults[N_RADIUS]);
  
  if(node==INVALID)
    {
      for (NodeIt i(ms.digraph); i!=INVALID; ++i)
	{
	  double v=fabs(actual_map[i]);
	  int w;
	  if(min==max)
	    {
	      w=(int)(node_property_defaults[N_RADIUS]);
	    }
	  else
	    {
	      w=(int)(MIN_NODE_RADIUS+(v-min)/(max-min)*(MAX_NODE_RADIUS-MIN_NODE_RADIUS));
	    }
	  if(zoomtrack)
	    {
	      double actual_ppu=get_pixels_per_unit();
	      w=(int)(w/actual_ppu*fixed_zoom_factor);
	    }
	  if(w>=0)
	    {
	      double x1, y1, x2, y2;
	      x1=nodesmap[i]->property_x1().get_value();
	      x2=nodesmap[i]->property_x2().get_value();
	      y1=nodesmap[i]->property_y1().get_value();
	      y2=nodesmap[i]->property_y2().get_value();
	      nodesmap[i]->property_x1().set_value((x1+x2)/2-w);
	      nodesmap[i]->property_x2().set_value((x1+x2)/2+w);
	      nodesmap[i]->property_y1().set_value((y1+y2)/2-w);
	      nodesmap[i]->property_y2().set_value((y1+y2)/2+w);
	    }
	}
    }
  else
    {
      //I think only new nodes use this case
//       int w=(int)actual_map[node];
      int w=(int)(node_property_defaults[N_RADIUS]);
      if(w>=0)
	{
	  double x1, y1, x2, y2;
	  x1=nodesmap[node]->property_x1().get_value();
	  x2=nodesmap[node]->property_x2().get_value();
	  y1=nodesmap[node]->property_y1().get_value();
	  y2=nodesmap[node]->property_y2().get_value();
	  nodesmap[node]->property_x1().set_value((x1+x2)/2-w);
	  nodesmap[node]->property_x2().set_value((x1+x2)/2+w);
	  nodesmap[node]->property_y1().set_value((y1+y2)/2-w);
	  nodesmap[node]->property_y2().set_value((y1+y2)/2+w);
	}
    }
  return 0;
};

int DigraphDisplayerCanvas::changeNodeColor (std::string mapname, Node node)
{  
  MapStorage& ms = *mytab.mapstorage;

  //function maps the range of the maximum and
  //the minimum of the nodemap to the range of
  //green in RGB

  double max, min;

  {
    NodeIt n(ms.digraph);
    min = max = ms.get(mapname, n);
    for (; n != INVALID; ++n)
    {
      if (static_cast<double>(ms.get(mapname, n)) > max)
        max = ms.get(mapname, n);
      if (static_cast<double>(ms.get(mapname, n)) < min)
        min = ms.get(mapname, n);
    }
  }

  if(node==INVALID)
    {

      for (NodeIt i(ms.digraph); i!=INVALID; ++i)
	{
	  Gdk::Color color;

	  double w=ms.get(mapname, i);

	  if(max!=min)
	    {
	      color=rainbowColorCounter(min, max, w);
	    }
	  else
	    {
	      color.set_rgb_p (0, 0, 1);
	    }

	  nodesmap[i]->property_fill_color_gdk().set_value(color);
	}
    }
  else
    {
      Gdk::Color color;

      double w=ms.get(mapname, node);

      if(max!=min)
	{
	  color=rainbowColorCounter(min, max, w);
	}
      else
	{
	  color.set_rgb_p (0, 0, 1);
	}

      nodesmap[node]->property_fill_color_gdk().set_value(color);
    }
  return 0;
};

int DigraphDisplayerCanvas::resetNodeColor (Node node)
{  
  MapStorage& ms = *mytab.mapstorage;

  //function maps the range of the maximum and
  //the minimum of the nodemap to the range of
  //green in RGB

  Digraph::NodeMap<double> actual_map(ms.digraph,node_property_defaults[N_COLOR]);

  double max, min;

  max=node_property_defaults[N_COLOR];
  min=node_property_defaults[N_COLOR];

  if(node==INVALID)
    {

      for (NodeIt i(ms.digraph); i!=INVALID; ++i)
	{
	  Gdk::Color color;

	  double w=actual_map[i];

	  if(max!=min)
	    {
	      color.set_rgb_p (0, 0, 100*(w-min)/(max-min));
	    }
	  else
	    {
	      color.set_rgb_p (0, 0, 100);
	    }

	  nodesmap[i]->property_fill_color_gdk().set_value(color);
	}
    }
  else
    {
      Gdk::Color color;

      double w=actual_map[node];

      if(max!=min)
	{
	  color.set_rgb_p (0, 0, 100*(w-min)/(max-min));
	}
      else
	{
	  color.set_rgb_p (0, 0, 100);
	}

      nodesmap[node]->property_fill_color_gdk().set_value(color);
    }
  return 0;
};

int DigraphDisplayerCanvas::changeNodeText (std::string mapname, Node node)
{
  MapStorage& ms = *mytab.mapstorage;

  //the number in the map will be written on the node
  //EXCEPT when the name of the map is Text, because
  //in that case empty string will be written, because
  //that is the deleter map

  if(node==INVALID)
    {
      for (NodeIt i(ms.digraph); i!=INVALID; ++i)
	{
	  nodemap_to_edit=mapname;

	  nodetextmap[i]->property_text().set_value(
              static_cast<std::string>(ms.get(mapname, i)));
	}
    }
  else
    {
      nodetextmap[node]->property_text().set_value(
          static_cast<std::string>(ms.get(mapname, node)));
    }
  return 0;
};

int DigraphDisplayerCanvas::resetNodeText (Node node)
{
  MapStorage& ms = *mytab.mapstorage;

  //the number in the map will be written on the node
  //EXCEPT when the name of the map is Text, because
  //in that case empty string will be written, because
  //that is the deleter map

  if(node==INVALID)
    {
      for (NodeIt i(ms.digraph); i!=INVALID; ++i)
	{
	  nodemap_to_edit="";
	  nodetextmap[i]->property_text().set_value("");
	}
    }
  else
    {
      nodetextmap[node]->property_text().set_value("");
    }
  return 0;
};
