#include "map_value.h"
#include <sstream>
#include <iostream>

MapValue::MapValue()
{
  //std::cout << __PRETTY_FUNCTION__ << std::endl;
  has_value = false;
}

MapValue::MapValue(double d)
{
  //std::cout << __PRETTY_FUNCTION__ << std::endl;
  p_value = new double(d);
  type = NUMERIC;
  has_value = true;
}

MapValue::MapValue(std::string str)
{
  //std::cout << __PRETTY_FUNCTION__ << std::endl;
  p_value = new std::string(str);
  type = STRING;
  has_value = true;
}

MapValue::MapValue(const char* str)
{
  //std::cout << __PRETTY_FUNCTION__ << std::endl;
  p_value = new std::string(str);
  type = STRING;
  has_value = true;
}

MapValue::operator double() const
{
  //std::cout << __PRETTY_FUNCTION__ << std::endl;
  if (!has_value) throw IllegalOperation();
  if (type == NUMERIC)
    return *(static_cast<double*>(p_value));
  else
    throw IllegalOperation();
}

MapValue::operator std::string() const
{
  //std::cout << __PRETTY_FUNCTION__ << std::endl;
  if (!has_value) throw IllegalOperation();
  std::string ret;
  switch (type)
  {
    case NUMERIC:
      {
        double d = *(static_cast<double*>(p_value));
        std::ostringstream ostr;
        ostr << d;
        ret = ostr.str();
      }
      break;
    case STRING:
      ret = *(static_cast<std::string*>(p_value));
      break;
  }
  return ret;
}

MapValue::MapValue(const MapValue& v)
{
  //std::cout << __PRETTY_FUNCTION__ << std::endl;
  if (!v.has_value) throw IllegalOperation();
  has_value = true;
  type = v.type;
  switch (v.type)
  {
    case NUMERIC:
      p_value = new double(*(static_cast<double*>(v.p_value)));
      break;
    case STRING:
      p_value = new std::string(*(static_cast<std::string*>(v.p_value)));
      break;
  }
}

MapValue& MapValue::operator=(const MapValue& v)
{
  //std::cout << __PRETTY_FUNCTION__ << std::endl;
  if (&v != this)
  {
    if (!v.has_value) throw IllegalOperation();
    clear();
    has_value = true;
    type = v.type;
    switch (v.type)
    {
      case NUMERIC:
        p_value = new double(*(static_cast<double*>(v.p_value)));
        break;
      case STRING:
        p_value = new std::string(*(static_cast<std::string*>(v.p_value)));
        break;
    }
  }
  return *this;
}

MapValue::~MapValue()
{
  //std::cout << __PRETTY_FUNCTION__ << std::endl;
  clear();
}

void MapValue::clear()
{
  //std::cout << __PRETTY_FUNCTION__ << std::endl;
  if (!has_value) return;
  switch (type)
  {
    case NUMERIC:
      delete static_cast<double*>(p_value);
      break;
    case STRING:
      delete static_cast<std::string*>(p_value);
      break;
  }
}

MapValue::Type MapValue::getType() const
{
  //std::cout << __PRETTY_FUNCTION__ << std::endl;
  return type;
}

bool MapValue::hasValue() const
{
  //std::cout << __PRETTY_FUNCTION__ << std::endl;
  return has_value;
}

std::ostream& operator<<(std::ostream &os, const MapValue& v)
{
  //std::cout << __PRETTY_FUNCTION__ << std::endl;
  if (!v.has_value) return os;
  switch (v.type)
  {
    case MapValue::NUMERIC:
      os << *(static_cast<double*>(v.p_value));
      break;
    case MapValue::STRING:
      os << *(static_cast<std::string*>(v.p_value));
      break;
  }
  return os;
}
