#include "map_value_map.h"
#include "mapstorage.h"

MapValueArcMap::MapValueArcMap(const std::string& _mapName, MapStorage* _pMapStorage) :
  mapName(_mapName),
  pMapStorage(_pMapStorage)
{
}

MapValueArcMap::Value MapValueArcMap::operator[](Key k) const {
  return pMapStorage->get(mapName, k);
}

void MapValueArcMap::set(Key k, Value v)
{
  pMapStorage->set(mapName, k, v);
}

MapValueNodeMap::MapValueNodeMap(const std::string& _mapName, MapStorage* _pMapStorage) :
  mapName(_mapName),
  pMapStorage(_pMapStorage)
{
}

MapValueNodeMap::Value MapValueNodeMap::operator[](Key k) const {
  return pMapStorage->get(mapName, k);
}

void MapValueNodeMap::set(Key k, Value v)
{
  pMapStorage->set(mapName, k, v);
}
