/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2006
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#ifndef MAP_WIN_H
#define MAP_WIN_H

class NoteBookTab;
class MapSelector;

#include <all_include.h>
#include <libgnomecanvasmm.h>
#include <libgnomecanvasmm/polygon.h>
#include "map_value.h"

///Digraph visualization setup window.

///This class is responsible for creating a window,
///on which the visualization attributes can be
///assigned to maps.
class MapWin : public Gtk::Window
{
protected:
  ///\ref NoteBookTab to that the \ref MapWin belongs to.
  NoteBookTab & mytab;

  ///Designing element
  Gtk::Table * table;
  
  ///\ref MapSelectors for each property

  ///Each property has an own \ref MapSelector through which
  ///the map to visualize by the property van be set.
  MapSelector ** e_combo_array;

  ///\ref MapSelectors for each property

  ///Each property has an own \ref MapSelector through which
  ///the map to visualize by the property van be set.
  MapSelector ** n_combo_array;

  ///Information holder
  Gtk::Label * label;

  ///Container in which elements are organized.
  Gtk::VBox vbox;

public:
  ///Constructor

  ///It creates the widgets shown in \ref MapWin and
  ///binds the needed signal to the correct place.
  ///\param title title of window
  ///\param mw the owner \ref NoteBookTab (\ref mytab)
  MapWin(const std::string& title, 
      std::vector<std::string> n_eml,
      std::vector<std::string> s_eml,
      std::vector<std::string> n_nml,
      std::vector<std::string> s_nml,
      NoteBookTab & mw);

  ///Deregistrates \ref MapWin in its \ref NoteBookTab (\ref mytab)
  virtual bool on_delete_event(GdkEventAny *);

  ///Handles changement in nodemap selection

  ///If \ref MapSelector emits a signal that indicates
  ///changement in nodemap selection this function will
  ///be called. It calls the appropriate handler function,
  ///\ref NoteBookTab::propertyChange with parameters describing the changement.
  ///\param mapname the recently selected map
  ///\param prop the changed property
  void nodeMapChanged(std::string mapname, int prop);

  ///Handles changement in arcmap selection

  ///If \ref MapSelector emits a signal that indicates
  ///changement in arcmap selection this function will
  ///be called. It calls the appropriate handler function,
  ///\ref NoteBookTab::propertyChange with parameters describing the changement.
  ///\param mapname the recently selected map
  ///\param prop the changed property
  void arcMapChanged(std::string mapname, int prop);

  ///Indicates to the owner \ref NoteBookTab that a \ref NewMapWin should be opened.

  ///This function is bound to the
  ///signal emitted by the \ref MapSelector in case of
  ///the user wants to create a new map. It only pass the
  ///information further to the tab owning this \ref MapWin that is needed to open the
  ///\ref NewMapWin. (\ref NoteBookTab::popupNewMapWin)
  ///\param itisarc should the new map will be an arcmap? (or nodemap)
  void newMapWinNeeded(bool itisarc);

  ///This function inserts name of the new arcmap in the name list in \ref MapSelector s

  ///\param new_name
  ///name of new map
  void registerNewArcMap(std::string new_name, MapValue::Type type);

  ///This function inserts name of the new nodemap in the name list in \ref MapSelector s

  ///\param new_name
  ///name of new map
  void registerNewNodeMap(std::string new_name, MapValue::Type type);

  ///Close window if Esc key pressed.
  virtual bool closeIfEscapeIsPressed(GdkEventKey*);

  ///Updates list of maps in all \ref MapSelector

  ///This function is called by \ref NoteBookTab, when the file
  ///showed in it has changed, therefore the contained maps
  ///have changed as well. \ref NoteBookTab knows, whether it
  ///has to call this function or not from the \ref NoteBookTab::mapwinexists
  ///variable.
  void update(
    std::vector<std::string> n_eml,
    std::vector<std::string> s_eml,
    std::vector<std::string> n_nml,
    std::vector<std::string> s_nml);

  void changeEntry(bool, int, std::string);

  void set_title(std::string);
};

#endif //MAP_WIN_H
