#include "save_details_widget.h"
#include "mapstorage.h"

SaveDetailsWidget::SaveDetailsWidget(MapStorage* ms) :
  pMapStorage(ms)
{
  Gtk::Notebook* nb = Gtk::manage(new Gtk::Notebook);
  pack_start(*nb, Gtk::PACK_EXPAND_WIDGET);

  nb->set_tab_pos(Gtk::POS_TOP);

  Gtk::VBox* vblueMaps = Gtk::manage(new Gtk::VBox(false, 18));
  vblueMaps->set_border_width(12);

  Gtk::VBox* vbArcMaps = Gtk::manage(new Gtk::VBox(false, 18));
  vbArcMaps->set_border_width(12);

  Gtk::VBox* vbSpecMaps = Gtk::manage(new Gtk::VBox(false, 18));
  vbSpecMaps->set_border_width(12);

  Gtk::VBox* vbGuiSect = Gtk::manage(new Gtk::VBox(false, 18));
  vbGuiSect->set_border_width(12);

  nb->append_page(*vbSpecMaps, "Special Maps");
  nb->append_page(*vblueMaps, "Node Maps");
  nb->append_page(*vbArcMaps, "Arc Maps");
  nb->append_page(*vbGuiSect, "GUI Section");

  // child widgets of vbSpecMaps

  {
    Gtk::VBox* box1 = Gtk::manage(new Gtk::VBox(false, 6));
    vbSpecMaps->pack_start(*box1, Gtk::PACK_SHRINK);

    Gtk::Label* lblNodeCoordMap =
      Gtk::manage(new Gtk::Label("<b>Node Coordinates</b>"));
    lblNodeCoordMap->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
    lblNodeCoordMap->set_use_markup();
    box1->pack_start(*lblNodeCoordMap, Gtk::PACK_SHRINK);

    Gtk::HBox* box2 = Gtk::manage(new Gtk::HBox);
    box1->pack_start(*box2, Gtk::PACK_SHRINK);

    Gtk::Label* fill1 = Gtk::manage(new Gtk::Label("    "));
    box2->pack_start(*fill1, Gtk::PACK_SHRINK);

    Gtk::VBox* box3 = Gtk::manage(new Gtk::VBox);
    box2->pack_start(*box3, Gtk::PACK_SHRINK);

    rblueCoordGuiSection.set_label("Save to GUI section");
    rblueCoordNodesetSection.set_label("Save to Nodeset section");
    Gtk::RadioButtonGroup group = rblueCoordGuiSection.get_group();
    rblueCoordNodesetSection.set_group(group);

    box3->pack_start(rblueCoordGuiSection, Gtk::PACK_SHRINK);
    box3->pack_start(rblueCoordNodesetSection, Gtk::PACK_SHRINK);

    Gtk::HBox* box4 = Gtk::manage(new Gtk::HBox);
    box3->pack_start(*box4, Gtk::PACK_SHRINK);

    Gtk::Label* fill2 = Gtk::manage(new Gtk::Label("    "));
    box4->pack_start(*fill2, Gtk::PACK_SHRINK);

    Gtk::Table* table1 = Gtk::manage(new Gtk::Table(3, 2));
    box4->pack_start(*table1, Gtk::PACK_SHRINK);

    rblueCoordOneMap.set_label("As one map");
    rblueCoordTwoMaps.set_label("As two maps");
    group = rblueCoordOneMap.get_group();
    rblueCoordTwoMaps.set_group(group);

    table1->attach(rblueCoordOneMap, 0, 1, 0, 1);
    table1->attach(rblueCoordTwoMaps, 0, 1, 1, 2);
    table1->attach(entNodeCoordsOneMap, 1, 2, 0, 1);
    table1->attach(entNodeCoordsTwoMaps1, 1, 2, 1, 2);
    table1->attach(entNodeCoordsTwoMaps2, 1, 2, 2, 3);

    switch (pMapStorage->getNodeCoordsSaveDest())
    {
      case MapStorage::SpecMapSaveOpts::GUI_SECT:
        rblueCoordGuiSection.set_active();
        rblueCoordOneMap.set_sensitive(false);
        rblueCoordTwoMaps.set_sensitive(false);
        entNodeCoordsOneMap.set_sensitive(false);
        entNodeCoordsTwoMaps1.set_sensitive(false);
        entNodeCoordsTwoMaps2.set_sensitive(false);
        break;
      case MapStorage::SpecMapSaveOpts::NESET_SECT:
        rblueCoordNodesetSection.set_active();
        rblueCoordOneMap.set_sensitive(true);
        rblueCoordTwoMaps.set_sensitive(true);
        switch (pMapStorage->getNodeCoordsSaveMapNum())
        {
          case MapStorage::SpecMapSaveOpts::ONE_MAP:
            rblueCoordOneMap.set_active();
            entNodeCoordsOneMap.set_sensitive(true);
            entNodeCoordsTwoMaps1.set_sensitive(false);
            entNodeCoordsTwoMaps2.set_sensitive(false);
            break;
          case MapStorage::SpecMapSaveOpts::TWO_MAPS:
            rblueCoordTwoMaps.set_active();
            entNodeCoordsOneMap.set_sensitive(false);
            entNodeCoordsTwoMaps1.set_sensitive(true);
            entNodeCoordsTwoMaps2.set_sensitive(true);
            break;
        }
        break;
    }

    entNodeCoordsOneMap.set_text(pMapStorage->getNodeCoordsOneMapName());
    entNodeCoordsTwoMaps1.set_text(pMapStorage->getNodeCoordsTwoMaps1Name());
    entNodeCoordsTwoMaps2.set_text(pMapStorage->getNodeCoordsTwoMaps2Name());

    entNodeCoordsOneMap.signal_changed().connect(
        sigc::mem_fun(*this, &SaveDetailsWidget::onNodeCoordsOneMapName));
    entNodeCoordsTwoMaps1.signal_changed().connect(
        sigc::mem_fun(*this, &SaveDetailsWidget::onNodeCoordsTwoMaps1Name));
    entNodeCoordsTwoMaps2.signal_changed().connect(
        sigc::mem_fun(*this, &SaveDetailsWidget::onNodeCoordsTwoMaps2Name));

    rblueCoordGuiSection.signal_toggled().connect(
        sigc::mem_fun(*this, &SaveDetailsWidget::onNodeCoordSaveDestChanged));
    rblueCoordNodesetSection.signal_toggled().connect(
        sigc::mem_fun(*this, &SaveDetailsWidget::onNodeCoordSaveDestChanged));
    rblueCoordOneMap.signal_toggled().connect(
        sigc::mem_fun(*this, &SaveDetailsWidget::onNodeCoordMapNumChanged));
    rblueCoordTwoMaps.signal_toggled().connect(
        sigc::mem_fun(*this, &SaveDetailsWidget::onNodeCoordMapNumChanged));
  }

  {
    Gtk::VBox* box1 = Gtk::manage(new Gtk::VBox(false, 6));
    vbSpecMaps->pack_start(*box1, Gtk::PACK_SHRINK);

    Gtk::Label* lblArrowCoordMap =
      Gtk::manage(new Gtk::Label("<b>Arrow Coordinates</b>"));
    lblArrowCoordMap->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
    lblArrowCoordMap->set_use_markup();
    box1->pack_start(*lblArrowCoordMap, Gtk::PACK_SHRINK);

    Gtk::HBox* box2 = Gtk::manage(new Gtk::HBox);
    box1->pack_start(*box2, Gtk::PACK_SHRINK);

    Gtk::Label* fill1 = Gtk::manage(new Gtk::Label("    "));
    box2->pack_start(*fill1, Gtk::PACK_SHRINK);

    Gtk::VBox* box3 = Gtk::manage(new Gtk::VBox);
    box2->pack_start(*box3, Gtk::PACK_SHRINK);

    rbArrowCoordGuiSection.set_label("Save to GUI section");
    rbArrowCoordArcsetSection.set_label("Save to Arcset section");
    Gtk::RadioButtonGroup group = rbArrowCoordGuiSection.get_group();
    rbArrowCoordArcsetSection.set_group(group);

    box3->pack_start(rbArrowCoordGuiSection, Gtk::PACK_SHRINK);
    box3->pack_start(rbArrowCoordArcsetSection, Gtk::PACK_SHRINK);

    Gtk::HBox* box4 = Gtk::manage(new Gtk::HBox);
    box3->pack_start(*box4, Gtk::PACK_SHRINK);

    Gtk::Label* fill2 = Gtk::manage(new Gtk::Label("    "));
    box4->pack_start(*fill2, Gtk::PACK_SHRINK);

    Gtk::Table* table1 = Gtk::manage(new Gtk::Table(3, 2));
    box4->pack_start(*table1, Gtk::PACK_SHRINK);

    rbArrowCoordOneMap.set_label("As one map");
    rbArrowCoordTwoMaps.set_label("As two maps");
    group = rbArrowCoordOneMap.get_group();
    rbArrowCoordTwoMaps.set_group(group);

    table1->attach(rbArrowCoordOneMap, 0, 1, 0, 1);
    table1->attach(rbArrowCoordTwoMaps, 0, 1, 1, 2);
    table1->attach(entArrowCoordsOneMap, 1, 2, 0, 1);
    table1->attach(entArrowCoordsTwoMaps1, 1, 2, 1, 2);
    table1->attach(entArrowCoordsTwoMaps2, 1, 2, 2, 3);

    switch (pMapStorage->getArrowCoordsSaveDest())
    {
      case MapStorage::SpecMapSaveOpts::GUI_SECT:
        rbArrowCoordGuiSection.set_active();
        rbArrowCoordOneMap.set_sensitive(false);
        rbArrowCoordTwoMaps.set_sensitive(false);
        entArrowCoordsOneMap.set_sensitive(false);
        entArrowCoordsTwoMaps1.set_sensitive(false);
        entArrowCoordsTwoMaps2.set_sensitive(false);
        break;
      case MapStorage::SpecMapSaveOpts::NESET_SECT:
        rbArrowCoordArcsetSection.set_active();
        rbArrowCoordOneMap.set_sensitive(true);
        rbArrowCoordTwoMaps.set_sensitive(true);
        switch (pMapStorage->getArrowCoordsSaveMapNum())
        {
          case MapStorage::SpecMapSaveOpts::ONE_MAP:
            rbArrowCoordOneMap.set_active();
            entArrowCoordsOneMap.set_sensitive(true);
            entArrowCoordsTwoMaps1.set_sensitive(false);
            entArrowCoordsTwoMaps2.set_sensitive(false);
            break;
          case MapStorage::SpecMapSaveOpts::TWO_MAPS:
            rbArrowCoordTwoMaps.set_active();
            entArrowCoordsOneMap.set_sensitive(false);
            entArrowCoordsTwoMaps1.set_sensitive(true);
            entArrowCoordsTwoMaps2.set_sensitive(true);
            break;
        }
        break;
    }

    entArrowCoordsOneMap.set_text(pMapStorage->getArrowCoordsOneMapName());
    entArrowCoordsTwoMaps1.set_text(pMapStorage->getArrowCoordsTwoMaps1Name());
    entArrowCoordsTwoMaps2.set_text(pMapStorage->getArrowCoordsTwoMaps2Name());

    entArrowCoordsOneMap.signal_changed().connect(
        sigc::mem_fun(*this, &SaveDetailsWidget::onArrowCoordsOneMapName));
    entArrowCoordsTwoMaps1.signal_changed().connect(
        sigc::mem_fun(*this, &SaveDetailsWidget::onArrowCoordsTwoMaps1Name));
    entArrowCoordsTwoMaps2.signal_changed().connect(
        sigc::mem_fun(*this, &SaveDetailsWidget::onArrowCoordsTwoMaps2Name));

    rbArrowCoordGuiSection.signal_toggled().connect(
        sigc::mem_fun(*this, &SaveDetailsWidget::onArrowCoordSaveDestChanged));
    rbArrowCoordArcsetSection.signal_toggled().connect(
        sigc::mem_fun(*this, &SaveDetailsWidget::onArrowCoordSaveDestChanged));
    rbArrowCoordOneMap.signal_toggled().connect(
        sigc::mem_fun(*this, &SaveDetailsWidget::onArrowCoordMapNumChanged));
    rbArrowCoordTwoMaps.signal_toggled().connect(
        sigc::mem_fun(*this, &SaveDetailsWidget::onArrowCoordMapNumChanged));
  }

  // child widgets of vbGuiSect

  {
    Gtk::VBox* box1 = Gtk::manage(new Gtk::VBox(false, 6));
    vbGuiSect->pack_start(*box1, Gtk::PACK_SHRINK);

    Gtk::Label* lblGuiSectionSave =
      Gtk::manage(new Gtk::Label("<b>Save Destination</b>"));
    lblGuiSectionSave->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
    lblGuiSectionSave->set_use_markup();
    box1->pack_start(*lblGuiSectionSave, Gtk::PACK_SHRINK);

    rbLgfFile.set_label("Lgf file");
    rbConfFile.set_label("Conf file");

    Gtk::RadioButtonGroup group = rbLgfFile.get_group();
    rbConfFile.set_group(group);

    switch (pMapStorage->getGUIDataSaveLocation())
    {
      case MapStorage::LGF_FILE:
        rbLgfFile.set_active();
        break;
      case MapStorage::CONF_FILE:
        rbConfFile.set_active();
        break;
    }

    Gtk::HBox* box2 = Gtk::manage(new Gtk::HBox);
    box1->pack_start(*box2, Gtk::PACK_SHRINK);

    Gtk::Label* fill1 = Gtk::manage(new Gtk::Label("    "));
    box2->pack_start(*fill1, Gtk::PACK_SHRINK);

    Gtk::VBox* box3 = Gtk::manage(new Gtk::VBox);
    box2->pack_start(*box3, Gtk::PACK_SHRINK);

    box3->pack_start(rbLgfFile, Gtk::PACK_SHRINK);
    box3->pack_start(rbConfFile, Gtk::PACK_SHRINK);

    rbLgfFile.signal_toggled().connect(
        sigc::mem_fun(*this, &SaveDetailsWidget::onGuiSectSaveDestChanged));
    rbConfFile.signal_toggled().connect(
        sigc::mem_fun(*this, &SaveDetailsWidget::onGuiSectSaveDestChanged));
  }

  // child widgets of vblueMaps

  {
    Gtk::VBox* box1 = Gtk::manage(new Gtk::VBox(false, 6));
    vblueMaps->pack_start(*box1, Gtk::PACK_SHRINK);

    Gtk::Label* label1 =
      Gtk::manage(new Gtk::Label("<b>Save Destination</b>"));
    label1->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
    label1->set_use_markup();
    box1->pack_start(*label1, Gtk::PACK_SHRINK);

    Gtk::HBox* box2 = Gtk::manage(new Gtk::HBox);
    box1->pack_start(*box2, Gtk::PACK_SHRINK);

    Gtk::Label* fill1 = Gtk::manage(new Gtk::Label("    "));
    box2->pack_start(*fill1, Gtk::PACK_SHRINK);

    Gtk::Frame* frame = Gtk::manage(new Gtk::Frame);
    box2->pack_start(*frame, Gtk::PACK_EXPAND_WIDGET);

    Gtk::ScrolledWindow* swNodeMaps = Gtk::manage(new Gtk::ScrolledWindow);
    frame->add(*swNodeMaps);

    swNodeMaps->add(twNodeMaps);

    refNodeMapStore = Gtk::ListStore::create(NodeMapColumns);

    std::vector<std::string> node_maps = pMapStorage->getNodeMapList();
    for (std::vector<std::string>::const_iterator it = node_maps.begin();
        it != node_maps.end(); ++it)
    {
      Gtk::TreeModel::Row row = *(refNodeMapStore->append());
      row[NodeMapColumns.colName] = *it;
      switch (pMapStorage->getNodeMapSaveDest(*it))
      {
        case MapStorage::GUI_SECT:
          row[NodeMapColumns.colSaveToMainSect] = false;
          row[NodeMapColumns.colSaveToGuiSect] = true;
          break;
        case MapStorage::NESET_SECT:
          row[NodeMapColumns.colSaveToMainSect] = true;
          row[NodeMapColumns.colSaveToGuiSect] = false;
          break;
        case MapStorage::DONT_SAVE:
          row[NodeMapColumns.colSaveToMainSect] = false;
          row[NodeMapColumns.colSaveToGuiSect] = false;
          break;
      }
    }

    twNodeMaps.set_model(refNodeMapStore);
    twNodeMaps.append_column("Name", NodeMapColumns.colName);
    twNodeMaps.append_column_editable("Nodeset section",
        NodeMapColumns.colSaveToMainSect);
    twNodeMaps.append_column_editable("GUI section",
        NodeMapColumns.colSaveToGuiSect);

    swNodeMaps->set_size_request(-1, 200);
    swNodeMaps->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);

    refNodeMapStore->signal_row_changed().connect(
        sigc::mem_fun(*this, &SaveDetailsWidget::onNodeMapRowChanged));
  }

  // child widgets of vbArcMaps

  {
    Gtk::VBox* box1 = Gtk::manage(new Gtk::VBox(false, 6));
    vbArcMaps->pack_start(*box1, Gtk::PACK_SHRINK);

    Gtk::Label* label1 =
      Gtk::manage(new Gtk::Label("<b>Save Destination</b>"));
    label1->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
    label1->set_use_markup();
    box1->pack_start(*label1, Gtk::PACK_SHRINK);

    Gtk::HBox* box2 = Gtk::manage(new Gtk::HBox);
    box1->pack_start(*box2, Gtk::PACK_SHRINK);

    Gtk::Label* fill1 = Gtk::manage(new Gtk::Label("    "));
    box2->pack_start(*fill1, Gtk::PACK_SHRINK);

    Gtk::Frame* frame = Gtk::manage(new Gtk::Frame);
    box2->pack_start(*frame, Gtk::PACK_EXPAND_WIDGET);

    Gtk::ScrolledWindow* swArcMaps = Gtk::manage(new Gtk::ScrolledWindow);
    frame->add(*swArcMaps);

    swArcMaps->add(twArcMaps);

    refArcMapStore = Gtk::ListStore::create(ArcMapColumns);

    std::vector<std::string> arc_maps = pMapStorage->getArcMapList();
    for (std::vector<std::string>::const_iterator it = arc_maps.begin();
        it != arc_maps.end(); ++it)
    {
      Gtk::TreeModel::Row row = *(refArcMapStore->append());
      row[ArcMapColumns.colName] = *it;
      switch (pMapStorage->getArcMapSaveDest(*it))
      {
        case MapStorage::GUI_SECT:
          row[ArcMapColumns.colSaveToMainSect] = false;
          row[ArcMapColumns.colSaveToGuiSect] = true;
          break;
        case MapStorage::NESET_SECT:
          row[ArcMapColumns.colSaveToMainSect] = true;
          row[ArcMapColumns.colSaveToGuiSect] = false;
          break;
        case MapStorage::DONT_SAVE:
          row[ArcMapColumns.colSaveToMainSect] = false;
          row[ArcMapColumns.colSaveToGuiSect] = false;
          break;
      }
    }

    twArcMaps.set_model(refArcMapStore);
    twArcMaps.append_column("Name", ArcMapColumns.colName);
    twArcMaps.append_column_editable("Arcset section",
        ArcMapColumns.colSaveToMainSect);
    twArcMaps.append_column_editable("GUI section",
        ArcMapColumns.colSaveToGuiSect);

    swArcMaps->set_size_request(-1, 200);
    swArcMaps->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);

    refArcMapStore->signal_row_changed().connect(
        sigc::mem_fun(*this, &SaveDetailsWidget::onArcMapRowChanged));
  }

  show_all_children();
}

void SaveDetailsWidget::onGuiSectSaveDestChanged()
{
  if (rbLgfFile.get_active())
  {
    pMapStorage->setGUIDataSaveLocation(MapStorage::LGF_FILE);
  }
  else if (rbConfFile.get_active())
  {
    pMapStorage->setGUIDataSaveLocation(MapStorage::CONF_FILE);
  }
}

void SaveDetailsWidget::onArcMapRowChanged(const Gtk::TreeModel::Path& path,
    const Gtk::TreeModel::iterator& iter)
{
  Gtk::TreeModel::Row row = *iter;
  Glib::ustring map_name = row[ArcMapColumns.colName];
  if (row[ArcMapColumns.colSaveToMainSect] &&
      row[ArcMapColumns.colSaveToGuiSect])
  {
    if (pMapStorage->getArcMapSaveDest(map_name) == MapStorage::NESET_SECT)
    {
      pMapStorage->setArcMapSaveDest(map_name, MapStorage::GUI_SECT);
      row[ArcMapColumns.colSaveToMainSect] = false;
    }
    else
    {
      pMapStorage->setArcMapSaveDest(map_name, MapStorage::NESET_SECT);
      row[ArcMapColumns.colSaveToGuiSect] = false;
    }
  }
  else if (row[ArcMapColumns.colSaveToMainSect])
  {
    pMapStorage->setArcMapSaveDest(map_name, MapStorage::NESET_SECT);
  }
  else if (row[ArcMapColumns.colSaveToGuiSect])
  {
    pMapStorage->setArcMapSaveDest(map_name, MapStorage::GUI_SECT);
  }
  else
  {
    pMapStorage->setArcMapSaveDest(map_name, MapStorage::DONT_SAVE);
  }
}

void SaveDetailsWidget::onNodeMapRowChanged(const Gtk::TreeModel::Path& path,
    const Gtk::TreeModel::iterator& iter)
{
  Gtk::TreeModel::Row row = *iter;
  Glib::ustring map_name = row[NodeMapColumns.colName];
  if (row[NodeMapColumns.colSaveToMainSect] &&
      row[NodeMapColumns.colSaveToGuiSect])
  {
    if (pMapStorage->getNodeMapSaveDest(map_name) == MapStorage::NESET_SECT)
    {
      pMapStorage->setNodeMapSaveDest(map_name, MapStorage::GUI_SECT);
      row[NodeMapColumns.colSaveToMainSect] = false;
    }
    else
    {
      pMapStorage->setNodeMapSaveDest(map_name, MapStorage::NESET_SECT);
      row[NodeMapColumns.colSaveToGuiSect] = false;
    }
  }
  else if (row[NodeMapColumns.colSaveToMainSect])
  {
    pMapStorage->setNodeMapSaveDest(map_name, MapStorage::NESET_SECT);
  }
  else if (row[NodeMapColumns.colSaveToGuiSect])
  {
    pMapStorage->setNodeMapSaveDest(map_name, MapStorage::GUI_SECT);
  }
  else
  {
    pMapStorage->setNodeMapSaveDest(map_name, MapStorage::DONT_SAVE);
  }
}

void SaveDetailsWidget::onNodeCoordSaveDestChanged()
{
  if (rblueCoordGuiSection.get_active())
  {
    pMapStorage->setNodeCoordsSaveDest(MapStorage::SpecMapSaveOpts::GUI_SECT);
    rblueCoordOneMap.set_sensitive(false);
    rblueCoordTwoMaps.set_sensitive(false);
    entNodeCoordsOneMap.set_sensitive(false);
    entNodeCoordsTwoMaps1.set_sensitive(false);
    entNodeCoordsTwoMaps2.set_sensitive(false);
  }
  else if (rblueCoordNodesetSection.get_active())
  {
    pMapStorage->setNodeCoordsSaveDest(MapStorage::SpecMapSaveOpts::NESET_SECT);
    rblueCoordOneMap.set_sensitive(true);
    rblueCoordTwoMaps.set_sensitive(true);
    switch (pMapStorage->getNodeCoordsSaveMapNum())
    {
      case MapStorage::SpecMapSaveOpts::ONE_MAP:
        entNodeCoordsOneMap.set_sensitive(true);
        entNodeCoordsTwoMaps1.set_sensitive(false);
        entNodeCoordsTwoMaps2.set_sensitive(false);
        break;
      case MapStorage::SpecMapSaveOpts::TWO_MAPS:
        entNodeCoordsOneMap.set_sensitive(false);
        entNodeCoordsTwoMaps1.set_sensitive(true);
        entNodeCoordsTwoMaps2.set_sensitive(true);
        break;
    }
  }
}

void SaveDetailsWidget::onNodeCoordMapNumChanged()
{
  if (rblueCoordOneMap.get_active())
  {
    pMapStorage->setNodeCoordsSaveMapNum(MapStorage::SpecMapSaveOpts::ONE_MAP);
    entNodeCoordsOneMap.set_sensitive(true);
    entNodeCoordsTwoMaps1.set_sensitive(false);
    entNodeCoordsTwoMaps2.set_sensitive(false);
  }
  else if (rblueCoordTwoMaps.get_active())
  {
    pMapStorage->setNodeCoordsSaveMapNum(MapStorage::SpecMapSaveOpts::TWO_MAPS);
    entNodeCoordsOneMap.set_sensitive(false);
    entNodeCoordsTwoMaps1.set_sensitive(true);
    entNodeCoordsTwoMaps2.set_sensitive(true);
  }
}

void SaveDetailsWidget::onNodeCoordsOneMapName()
{
  pMapStorage->setNodeCoordsOneMapName(entNodeCoordsOneMap.get_text());
}
void SaveDetailsWidget::onNodeCoordsTwoMaps1Name()
{
  pMapStorage->setNodeCoordsTwoMaps1Name(entNodeCoordsTwoMaps1.get_text());
}
void SaveDetailsWidget::onNodeCoordsTwoMaps2Name()
{
  pMapStorage->setNodeCoordsTwoMaps2Name(entNodeCoordsTwoMaps2.get_text());
}

void SaveDetailsWidget::onArrowCoordSaveDestChanged()
{
  if (rbArrowCoordGuiSection.get_active())
  {
    pMapStorage->setArrowCoordsSaveDest(MapStorage::SpecMapSaveOpts::GUI_SECT);
    rbArrowCoordOneMap.set_sensitive(false);
    rbArrowCoordTwoMaps.set_sensitive(false);
    entArrowCoordsOneMap.set_sensitive(false);
    entArrowCoordsTwoMaps1.set_sensitive(false);
    entArrowCoordsTwoMaps2.set_sensitive(false);
  }
  else if (rbArrowCoordArcsetSection.get_active())
  {
    pMapStorage->setArrowCoordsSaveDest(MapStorage::SpecMapSaveOpts::NESET_SECT);
    rbArrowCoordOneMap.set_sensitive(true);
    rbArrowCoordTwoMaps.set_sensitive(true);
    switch (pMapStorage->getArrowCoordsSaveMapNum())
    {
      case MapStorage::SpecMapSaveOpts::ONE_MAP:
        entArrowCoordsOneMap.set_sensitive(true);
        entArrowCoordsTwoMaps1.set_sensitive(false);
        entArrowCoordsTwoMaps2.set_sensitive(false);
        break;
      case MapStorage::SpecMapSaveOpts::TWO_MAPS:
        entArrowCoordsOneMap.set_sensitive(false);
        entArrowCoordsTwoMaps1.set_sensitive(true);
        entArrowCoordsTwoMaps2.set_sensitive(true);
        break;
    }
  }
}

void SaveDetailsWidget::onArrowCoordMapNumChanged()
{
  if (rbArrowCoordOneMap.get_active())
  {
    pMapStorage->setArrowCoordsSaveMapNum(MapStorage::SpecMapSaveOpts::ONE_MAP);
    entArrowCoordsOneMap.set_sensitive(true);
    entArrowCoordsTwoMaps1.set_sensitive(false);
    entArrowCoordsTwoMaps2.set_sensitive(false);
  }
  else if (rbArrowCoordTwoMaps.get_active())
  {
    pMapStorage->setArrowCoordsSaveMapNum(MapStorage::SpecMapSaveOpts::TWO_MAPS);
    entArrowCoordsOneMap.set_sensitive(false);
    entArrowCoordsTwoMaps1.set_sensitive(true);
    entArrowCoordsTwoMaps2.set_sensitive(true);
  }
}

void SaveDetailsWidget::onArrowCoordsOneMapName()
{
  pMapStorage->setArrowCoordsOneMapName(entArrowCoordsOneMap.get_text());
}
void SaveDetailsWidget::onArrowCoordsTwoMaps1Name()
{
  pMapStorage->setArrowCoordsTwoMaps1Name(entArrowCoordsTwoMaps1.get_text());
}
void SaveDetailsWidget::onArrowCoordsTwoMaps2Name()
{
  pMapStorage->setArrowCoordsTwoMaps2Name(entArrowCoordsTwoMaps2.get_text());
}

SaveDetailsWidget::~SaveDetailsWidget()
{
}
