#include <benchmark_tools.h>
#include <lemon/circulation.h>
#include <lemon/smart_graph.h>
#include <lemon/lgf_reader.h>
#include <lemon/dimacs.h>
#include <lemon/error.h>

const char test_name[] = "circulation";

using namespace lemon;

int testMain(int argc, char **argv)
{
  if(argc!=2) exit(1);

  typedef int Value;
  
  SmartDigraph g;
  
  SmartDigraph::ArcMap<Value> lo_cap(g);
  SmartDigraph::ArcMap<Value> up_cap(g);
  SmartDigraph::ArcMap<Value> cost(g);
  SmartDigraph::NodeMap<Value> sup(g);
  
  Timer ti;
  try {
    std::ifstream input;
    input.open(argv[1]);
    readDimacsMin(input, g, lo_cap, up_cap, cost, sup);
  } catch (FormatError& error) {
    std::cerr << error.what() << std::endl;
    return 1;
  }
  logTime("file-read",ti);

  Timer tf;
  ti.restart();
  Circulation<SmartDigraph,
    SmartDigraph::ArcMap<Value>,SmartDigraph::ArcMap<Value>,
    SmartDigraph::NodeMap<Value> > circ(g,lo_cap,up_cap,sup);
  logTime("setup",ti);
  ti.restart();
  bool res = circ.run();
  logTime("alg",ti);
  logTime("full",tf);
  if(res)
    {
      std::cerr << "A feasible circulation is found\n";
      std::cerr << "Checking...\n";
      ti.restart();
      bool res2 = circ.checkFlow();
      logTime("check",ti);
      if(res2)
        std::cerr << "Success!\n";
      else
        std::cerr << "Oops!!!!\n";
    }
  else
    {
      std::cerr << "A dual solution is found\n";
      std::cerr << "Checking...\n";
      ti.restart();
      bool res2 = circ.checkBarrier();
      logTime("check",ti);
      if(res2)
        std::cerr << "Success!\n";
      else
        std::cerr << "Dual-Oops!!!!\n";

    }
}

