#include <iostream>
#include <fstream>

#include <lemon/list_graph.h>
#include <lemon/smart_graph.h>
#include <lemon/dimacs.h>
#include <merge_node_graph_wrapper.h>

#include<lemon/concept_check.h>
#include<lemon/concept/graph.h>

using std::cout;
using std::endl;

using namespace lemon;
using namespace lemon::concept;

class Graph3 : ListGraph {
public:
  class Node : public ListGraph::Node { };
  class Edge { };
};

int main() {
  typedef SmartGraph Graph1;
  typedef ListGraph Graph2;
  
  {
    checkConcept<StaticGraph, NewEdgeSetGraphWrapper<Graph1, Graph2> >(); 
  }
  {
    checkConcept<StaticGraph, MergeEdgeGraphWrapper<Graph1, Graph2> >(); 
  }
  
  Graph1 g;
  Graph2 h;
  typedef MergeEdgeGraphWrapper<Graph1, Graph2> GW;
  GW gw(g, h);

  std::ifstream f1("graph1.dim");
  std::ifstream f2("graph2.dim");
  readDimacs(f1, g);
  readDimacs(f2, h);
  {

//   Graph1::Node n1=g.addNode();
//   Graph1::Node n2=g.addNode();
//   Graph1::Node n3=g.addNode();
//   Graph2::Node n4=h.addNode();
//   Graph2::Node n5=h.addNode();
//   Graph2::Node n6=h.addNode();
//   Graph1::Edge e1=g.addEdge(n1, n2);
//   Graph1::Edge e2=g.addEdge(n1, n3);
//   Graph2::Edge e3=h.addEdge(n4, n5);
//   Graph2::Edge e4=h.addEdge(n4, n5);
  //GW::NodeIt n(gw)
  cout << "1st graph" << endl;
  cout << " nodes:" << endl;
  for (Graph1::NodeIt n(g); n!=INVALID; ++n) { 
    cout << "  " << g.id(n) << endl;
  }
  cout << " edges:" << endl;
  for (Graph1::EdgeIt n(g); n!=INVALID; ++n) { 
    cout << "  " << g.id(n) << ": " 
	 << g.id(g.source(n)) << "->" << g.id(g.target(n)) << endl;
  }
  cout << "2nd graph" << endl;
  cout << " nodes:" << endl;
  for (Graph2::NodeIt n(h); n!=INVALID; ++n) { 
    cout << "  " << h.id(n) << endl;
  }
  cout << " edges:" << endl;
  for (Graph2::EdgeIt n(h); n!=INVALID; ++n) { 
    cout << "  " << h.id(n) << ": " 
	 << h.id(h.source(n)) << "->" << h.id(h.target(n)) << endl;
  }
  cout << "merged graph" << endl;
  cout << " nodes:" << endl;
  for (GW::NodeIt n(gw); n!=INVALID; ++n) { 
    cout << "  "<< gw.id(n) << endl;
  }
  cout << " edges:" << endl;
  for (GW::EdgeIt n(gw); n!=INVALID; ++n) { 
    cout << "  " << gw.id(n) << ": " 
	 << gw.id(gw.source(n)) << "->" << gw.id(gw.target(n)) << endl;
  }

  GW::NodeMap<int> nm(gw);
  int i=0;
  for (GW::NodeIt n(gw); n!=INVALID; ++n) { 
    ++i;
    nm.set(n, i);
  }
  for (Graph1::NodeIt n(g); n!=INVALID; ++n) { 
    cout << nm[GW::Node(n,INVALID,false)] << endl;
  }
  for (Graph2::NodeIt n(h); n!=INVALID; ++n) { 
    cout << nm[GW::Node(INVALID,n,true)] << endl;
  }

  gw.printNode();

  {
//    typedef SmartGraph Graph1;
    typedef ListGraph Graph1;
    typedef ListGraph Graph2;
    Graph1 g;
    Graph2 h;
    typedef MergeNodeGraphWrapper<Graph1, Graph2> GW;
    GW gw(g, h);    
    gw.printNode();
  }
  {
//    typedef SmartGraph Graph1;
    typedef Graph3 Graph1;
    typedef ListGraph Graph2;
    Graph1 g;
    Graph2 h;
    typedef MergeNodeGraphWrapper<Graph1, Graph2> GW;
    GW gw(g, h);    
    gw.printNode();
  }
  {
//    typedef SmartGraph Graph1;
    typedef ListGraph Graph1;
    typedef Graph3 Graph2;
    Graph1 g;
    Graph2 h;
    typedef MergeNodeGraphWrapper<Graph1, Graph2> GW;
    GW gw(g, h);    
    gw.printNode();
  }
  }
  {
    Graph1 g;
    Graph2 h;
    typedef Graph1::Node Node1;
    typedef Graph2::Node Node2;
    typedef NewEdgeSetGraphWrapper<Graph1, Graph2> GW;
    Graph1::NodeMap<Graph2::Node> e_node(g);
    Graph2::NodeMap<Graph1::Node> n_node(h);
    GW gw(g, h, e_node, n_node);
    for (int i=0; i<4; ++i) { 
      Node1 n=g.addNode();
      e_node.set(n, INVALID);
    }
    for (int i=0; i<4; ++i) {
      Graph1::Node n1=g.addNode();
      Graph2::Node n2=h.addNode();
      e_node.set(n1, n2);
      n_node.set(n2, n1);
    }
    for (Graph2::NodeIt n(h); n!=INVALID; ++n)
      for (Graph2::NodeIt m(h); m!=INVALID; ++m)
	if ((h.id(n)+h.id(m))%3==0) h.addEdge(n, m);
//     Graph1::NodeIt n(g);
//     Node1 n1=n;
//     Node1 n2=++n;
//     Node1 n3=++n;
//     Node1 n4=n;
//     gw.addEdge(n1, n2);
//     gw.addEdge(n1, n2);
//     for (EdgeIt(e))
//   Graph1::Node n1=g.addNode();
//   Graph1::Node n2=g.addNode();
//   Graph1::Node n3=g.addNode();
//   Graph2::Node n4=h.addNode();
//   Graph2::Node n5=h.addNode();
    for (GW::EdgeIt e(gw); e!=INVALID; ++e) 
      cout << gw.id(e) << endl;
    for (GW::NodeIt n(gw); n!=INVALID; ++n) {
      if (e_node[n]==INVALID) {
 	cout<<gw.id(n)<<" INVALID"<<endl;
      } else {
	cout <<gw.id(n)<<" "<<h.id(e_node[n])<<" out_edges: ";
	//	cout << &e_node << endl;
	//cout << &n_node << endl;
	for (GW::OutEdgeIt e(gw, n); e!=INVALID; ++e) {
	  cout<<gw.id(e)<<" ";
	}
	cout<< endl;
      }
    }
  }
}
