#include <lemon/smart_graph.h>
#include <lemon/graph_reader.h>

#include <iostream>
#include <fstream>

using namespace std;
using namespace lemon;

int main() {
  ifstream input("test.lgf");
  SmartGraph graph;
  GraphReader<SmartGraph> reader(input, graph);
  SmartGraph::NodeMap<int> cost(graph);
  reader.readNodeMap("cost", cost);
  SmartGraph::NodeMap<string> color(graph);
  reader.readNodeMap("color", color);
  reader.read();
  for (SmartGraph::NodeIt it(graph); it != INVALID; ++it) {
    cout << cost[it] << color[it] << endl;
  }
  return 0;
}
