#include <lemon/smart_graph.h>

#include "map_utils.h"


#include "graph_reader.h"
#include "graph_writer.h"

#include <iostream>
#include <fstream>

using namespace std;
using namespace lemon;

int main() {
  ifstream input("test.lgf");
  SmartGraph graph;
  GraphReader<SmartGraph> reader(input, graph);

  SmartGraph::NodeMap<int> id(graph);
  reader.readNodeMap("id", id);

  SmartGraph::NodeMap<int> cost(graph);
  reader.readNodeMap("cost", cost);
 
  SmartGraph::NodeMap<string> color(graph);
  reader.readNodeMap("color", color);

  SmartGraph::NodeMap<string> description(graph);
  reader.readNodeMap<QuotedStringReader>("description", description);

  SmartGraph::EdgeMap<char> mmap(graph);
  reader.readEdgeMap("mmap", mmap);

  reader.skipEdgeMap<QuotedStringReader>("description");

  SmartGraph::Node source;
  reader.readNode("source", source);
  
  SmartGraph::Edge newedge;
  reader.readEdge("newedge", newedge);

  try {
    reader.read();
  } catch (IOException& e) {
    cerr << e.what() << endl;
  } catch (Exception e) {
    cerr << e.what() << endl;
  }
  for (SmartGraph::NodeIt it(graph); it != INVALID; ++it) {
    cout << cost[it] << ' ' << color[it] << ' ' << description[it] << endl;
  }

  for (SmartGraph::EdgeIt it(graph); it != INVALID; ++it) {
    cout << mmap[it] << ' ' << id[graph.source(it)] << ' ' << id[graph.target(it)]  << endl;
  }

  cout << id[source] << ' ' << cost[source] << ' ' << color[source] << ' ' << description[source] << endl;
  cout << mmap[newedge] << ' ' << id[graph.source(newedge)] << ' ' << id[graph.target(newedge)]  << endl;

  ofstream output("copy.lgf");
  GraphWriter<SmartGraph> writer(output, graph);
  
  DescriptorMap<SmartGraph, SmartGraph::Node, SmartGraph::NodeIt, SmartGraph::NodeMap<int> > node_ids(graph);
  
  writer.writeNodeMap("id", node_ids);
  writer.writeNodeMap<QuotedStringWriter>("format", description);

  DescriptorMap<SmartGraph, SmartGraph::Edge, SmartGraph::EdgeIt, SmartGraph::EdgeMap<int> > edge_ids(graph);

  writer.writeEdgeMap("id", edge_ids);
  writer.writeEdgeMap("chars", mmap);
  
  writer.writeNode("source", node_ids.inverse()[3]);
  writer.writeEdge("elek", edge_ids.inverse()[6]);
  writer.write();
  
  return 0;
}
