#include <iostream>
#include <memory>

#include <boost/shared_ptr.hpp>

using namespace std;

class Ex : public exception {

  typedef exception Parent;

  mutable
  auto_ptr<string> uz;
public:

  // boost::shared_ptr<string> uz;

  Ex(const Ex &e) : Parent(e), uz(e.uz) {}

  explicit
  Ex(const char *msg = 0) {
    if( msg ) {
      try {
	uz.reset(new string);
	*uz = msg;
      }
      catch(...) {
	uz.reset();
      }
    }
  }

  virtual
  const char* what() const throw() {
    if( uz.get() )
      return uz->c_str();
    return "Kivetel";
  }

  virtual ~Ex() throw() {}
};

static void fn1() {
  Ex e("alma");
  throw e;
}

static
void fn2() {
  throw Ex("korte");
}

int main() {
  try {
    fn1();
  }
  catch(exception const &e) {
    cerr << "Hiba: " << e.what() << endl;
  }

  try {
    fn2();
  }
  catch(exception const &e) {
    cerr << "Hiba: " << e.what() << endl;
  }

}
