dnl LX_C_IFDEF(MACRO-NAME, ACTION-IF-DEF, ACTION-IF-NOT-DEF)
dnl
dnl Check for the definition of macro MACRO-NAME using the current
dnl language's compiler.
dnl
dnl Orignally written by Ludovic Courtès <ludo@chbouib.org>
AC_DEFUN([LX_C_IFDEF],
  [AC_COMPILE_IFELSE([#ifndef $1
                      # error "Macro $1 is undefined!"
                      /* For some compilers (eg. SGI's CC), #error is not
                         enough...  */
                      please, do fail
                      #endif],
                     [$2], [$3])])


dnl LX_CXX_COMPILER_VENDOR(VENDOR-NAME, [NICKNAME])
dnl
dnl Set VENDOR-NAME to the lower-case name of the compiler vendor or
dnl `unknown' if the compiler's vendor is unknown. `compaq' means the
dnl CXX compiler as available on Tru64/OSF1/Digital Unix on Alpha
dnl machines. If NICKNAME is provided, set it to the compiler's usual
dnl name (eg. `g++', `cxx', `aCC', etc.).
dnl
dnl Based on work of Ludovic Courtès <ludo@chbouib.org>
AC_DEFUN([LX_CXX_COMPILER_VENDOR],
  [AC_REQUIRE([AC_PROG_CXX])
   AC_REQUIRE([AC_PROG_CXXCPP])
   AC_CACHE_CHECK([the C++ compiler vendor],
    [lx_cv_cxx_compiler_vendor],

    [AC_LANG_PUSH([C++])

     dnl Intel's icpc
     LX_C_IFDEF([__INTEL_COMPILER],
       [lx_cv_cxx_compiler_vendor=intel],
       [dnl GNU C++
        LX_C_IFDEF([__GNUG__],
         [lx_cv_cxx_compiler_vendor=gnu],
         [LX_C_IFDEF([__DECCXX],
           [lx_cv_cxx_compiler_vendor=compaq],
           [dnl HP's aCC
            LX_C_IFDEF([__HP_aCC],
             [lx_cv_cxx_compiler_vendor=hp],
             [dnl SGI CC
              LX_C_IFDEF([__sgi],
               [lx_cv_cxx_compiler_vendor=sgi],
               [dnl Note:  We are using the C compiler because VC++ doesn't
                dnl recognize `.cc'(which is used by `configure') as a C++ file
                dnl extension and requires `/TP' to be passed.
                AC_LANG_PUSH([C])
                LX_C_IFDEF([_MSC_VER],
                  [lx_cv_cxx_compiler_vendor=microsoft],
                  [lx_cv_cxx_compiler_vendor=unknown])
                AC_LANG_POP()])])])])])

     AC_LANG_POP()])
   $1="$lx_cv_cxx_compiler_vendor"

   dnl The compiler nickname
   ifelse([$2], , [],
     [case "$lx_cv_cxx_compiler_vendor" in
        intel)     $2=icpc;;
        gnu)       $2=g++;;
        compaq)    $2=cxx;;
        hp)        $2=aCC;;
        sgi)       $2=CC;;
        microsoft) $2=cl;;
        *)         $2=unknown;;
      esac])])


dnl Set some debugging and error reporting related compiler flags.
dnl uses lx_user_cxxflags
AC_DEFUN([LX_SET_CXXFLAGS],
  [AC_ARG_ENABLE([debug],
AS_HELP_STRING([--enable-debug@<:@=yes|no|full@:>@], [Build with debugging support])
AS_HELP_STRING([--disable-debug], [Build without debugging support @<:@default@:>@]),
     [], [enable_debug=no])
   LX_CXX_COMPILER_VENDOR([lx_cxx_compiler_vendor])
   AC_MSG_CHECKING([whether to build with debugging support])
   if test x"$enable_debug" != x"no"; then
     AC_DEFINE([DEBUG], [1], [Define for debugging support])

     lx_gnu_cxxflags="-ansi -pedantic -Wall -Wextra"
     lx_intel_cxxflags="-g"
     lx_unknown_cxxflags="-g"

     if test x"$enable_debug" = x"yes"; then
       lx_gnu_cxxflags="-g $lx_gnu_cxxflags"
       AC_MSG_RESULT([yes])
     else
       lx_gnu_cxxflags="-g3 --no-inline $lx_gnu_cxxflags"
       AC_MSG_RESULT([full])
     fi

     if test x"$lx_cxx_compiler_vendor" = x"gnu"; then
       CXXFLAGS="$lx_user_cxxflags $lx_gnu_cxxflags"
     elif test x"$lx_cxx_compiler_vendor" = x"intel"; then
       CXXFLAGS="$lx_user_cxxflags $lx_intel_cxxflags"
     else
       CXXFLAGS="$lx_user_cxxflags $lx_unknown_cxxflags"
     fi
   else
     AC_MSG_RESULT([no])
   fi

   AC_ARG_ENABLE([extra-warnings],
AS_HELP_STRING([--enable-extra-warnings], [Enable extra warning messages])
AS_HELP_STRING([--disable-extra-warnings], [Disable extra warning messages @<:@default@:>@]),
     [],[enable_extra_warnings=no])
   AC_MSG_CHECKING(whether to enable extra warning flags)
   if test x"$enable_extra_warnings" != x"no"; then
     if test x"$lx_cxx_compiler_vendor" = x"gnu"; then
       CXXFLAGS="$CXXFLAGS -ansi -pedantic -Wall -Wextra"
       CXXFLAGS="$CXXFLAGS -Wfloat-equal -Wundef -Wendif-labels -Wshadow"
       CXXFLAGS="$CXXFLAGS -Wpointer-arith -Wcast-qual -Wcast-align"
       CXXFLAGS="$CXXFLAGS -Wwrite-strings -Wconversion -Waggregate-return"
       CXXFLAGS="$CXXFLAGS -Wmissing-noreturn -Wmissing-format-attribute"
       CXXFLAGS="$CXXFLAGS -Wpacked -Wpadded -Wredundant-decls"
       CXXFLAGS="$CXXFLAGS -Wunreachable-code -Winline -Winvalid-pch"
       CXXFLAGS="$CXXFLAGS -Wlong-long -Wdisabled-optimization"
       CXXFLAGS="$CXXFLAGS -Wstack-protector"
     elif test x"$lx_cxx_compiler_vendor" = x"intel"; then
       CXXFLAGS="$CXXFLAGS -w2"
     fi
     AC_MSG_RESULT([yes])
   else
     AC_MSG_RESULT([no])
   fi])
