#include <iostream>
#include <fstream>

#include <list_graph.hh>
#include <dimacs.hh>
#include <edmonds_karp.hh>
#include <time_measure.h>
#include <graph_wrapper.h>

using namespace hugo;

// Use a DIMACS max flow file as stdin.
// read_dimacs_demo < dimacs_max_flow_file

/*
  struct Ize {
  };
  
  struct Mize {
    Ize bumm;
  };

  template <typename B>
    class Huha {
    public:
      int u;
      B brr;
    };
*/

int main(int, char **) {
  typedef ListGraph::NodeIt NodeIt;
  typedef ListGraph::EachEdgeIt EachEdgeIt;

/*
  Mize mize[10];
  Mize bize[0];
  Mize zize;
  typedef Mize Tize[0];

  std::cout << &zize << " " << sizeof(mize) << sizeof(Tize) << std::endl;
  std::cout << sizeof(bize) << std::endl;


  Huha<Tize> k;
  std::cout << sizeof(k) << std::endl;


  struct Bumm {
    //int a;
    bool b;
  };

  std::cout << sizeof(Bumm) << std::endl;
*/

  ListGraph G;
  NodeIt s, t;
  ListGraph::EdgeMap<int> cap(G);
  readDimacsMaxFlow(std::cin, G, s, t, cap);
/*
  typedef TrivGraphWrapper<ListGraph> TGW;
  TGW gw(G);
  TGW::EachNodeIt sw;
  gw.getFirst(sw);
  std::cout << "p1:" << gw.nodeNum() << std::endl;
  gw.erase(sw);
  std::cout << "p2:" << gw.nodeNum() << std::endl;

  typedef const ListGraph cLG;
  typedef TrivGraphWrapper<const cLG> CTGW;
  CTGW cgw(G);
  CTGW::EachNodeIt csw;
  cgw.getFirst(csw);
  std::cout << "p1:" << cgw.nodeNum() << std::endl;
  //cgw.erase(csw);
  std::cout << "p2:" << cgw.nodeNum() << std::endl;
*/

  {
  std::cout << "edmonds karp demo (blocking flow augmentation)..." << std::endl;
  ListGraph::EdgeMap<int> flow(G); //0 flow

  Timer ts;
  ts.reset();
  //double pre_time=currTime();
  MaxFlow<ListGraph, int, ListGraph::EdgeMap<int>, ListGraph::EdgeMap<int> > max_flow_test(G, s, t, flow, cap);
  //max_flow_test.augmentWithBlockingFlow<ListGraph>();
  int i=0;
  while (max_flow_test.augmentOnBlockingFlow<ListGraph>()) { 
//     for(EachEdgeIt e=G.template first<EachEdgeIt>(); e.valid(); ++e) { 
//       std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
//     }
//     std::cout<<std::endl;
    ++i; 
  }
  //double post_time=currTime();

  //std::cout << "maximum flow: "<< std::endl;
  //for(EachEdgeIt e=G.first<EachEdgeIt>(); e.valid(); ++e) { 
  //  std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
  //}
  //std::cout<<std::endl;
  std::cout << "elapsed time: " << ts << std::endl;
  std::cout << "number of augmentation phases: " << i << std::endl; 
  std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }

  {
  std::cout << "edmonds karp demo (blocking flow augmentation)..." << std::endl;
  ListGraph::EdgeMap<int> flow(G); //0 flow

  Timer ts;
  ts.reset();
  //double pre_time=currTime();
  MaxFlow<ListGraph, int, ListGraph::EdgeMap<int>, ListGraph::EdgeMap<int> > max_flow_test(G, s, t, flow, cap);
  //max_flow_test.augmentWithBlockingFlow<ListGraph>();
  int i=0;
  while (max_flow_test.augmentOnBlockingFlow2()) { 
//     for(EachEdgeIt e=G.template first<EachEdgeIt>(); e.valid(); ++e) { 
//       std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
//     }
//     std::cout<<std::endl;
    ++i; 
  }
  //double post_time=currTime();

  //std::cout << "maximum flow: "<< std::endl;
  //for(EachEdgeIt e=G.first<EachEdgeIt>(); e.valid(); ++e) { 
  //  std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
  //}
  //std::cout<<std::endl;
  std::cout << "elapsed time: " << ts << std::endl;
  std::cout << "number of augmentation phases: " << i << std::endl; 
  std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }

  {
  std::cout << "edmonds karp demo (shortest path augmentation)..." << std::endl;
  ListGraph::EdgeMap<int> flow(G); //0 flow

  Timer ts;
  ts.reset();
  //double pre_time=currTime();
  MaxFlow<ListGraph, int, ListGraph::EdgeMap<int>, ListGraph::EdgeMap<int> > max_flow_test(G, s, t, flow, cap);
  //max_flow_test.augmentWithBlockingFlow<ListGraph>();
  int i=0;
  while (max_flow_test.augmentOnShortestPath()) { 
//     for(EachEdgeIt e=G.template first<EachEdgeIt>(); e.valid(); ++e) { 
//       std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
//     }
//     std::cout<<std::endl;
    ++i; 
  }
  //double post_time=currTime();

  //std::cout << "maximum flow: "<< std::endl;
  //for(EachEdgeIt e=G.first<EachEdgeIt>(); e.valid(); ++e) { 
  //  std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
  //}
  //std::cout<<std::endl;
  std::cout << "elapsed time: " << ts << std::endl;
  std::cout << "number of augmentation phases: " << i << std::endl; 
  std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }

  return 0;
}
