/* -*- C++ -*-
 * src/test/graph_test.cc - Part of HUGOlib, a generic C++ optimization library
 *
 * Copyright (C) 2004 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include<iostream>
#include<hugo/smart_graph.h>
#include<hugo/skeletons/graph.h>
#include<hugo/list_graph.h>
#include<hugo/full_graph.h>

#include"test_tools.h"
#include"graph_test.h"

/**
\file
This test makes consistency checks of list graph structures.

G.addNode(), G.addEdge(), G.tail(), G.head()

\todo Checks for empty graphs and isolated points.
conversion.
*/

using namespace hugo;

template<class Graph> void bidirPetersen(Graph &G)
{
  typedef typename Graph::Edge Edge;
  typedef typename Graph::EdgeIt EdgeIt;
  
  checkGraphEdgeList(G,15);
  
  std::vector<Edge> ee;
  
  for(EdgeIt e(G);e!=INVALID;++e) ee.push_back(e);

  for(typename std::vector<Edge>::iterator p=ee.begin();p!=ee.end();p++)
    G.addEdge(G.head(*p),G.tail(*p));
}

template<class Graph> void checkPetersen(Graph &G)
{
  typedef typename Graph::Node Node;

  typedef typename Graph::EdgeIt EdgeIt;
  typedef typename Graph::NodeIt NodeIt;

  checkGraphNodeList(G,10);
  checkGraphEdgeList(G,30);

  for(NodeIt n(G);n!=INVALID;++n) {
    checkGraphInEdgeList(G,n,3);
    checkGraphOutEdgeList(G,n,3);
  }  
}

//Compile Graph
template void hugo::checkCompileStaticGraph<skeleton::StaticGraph>
(skeleton::StaticGraph &);

template void hugo::checkCompileGraph<skeleton::ExtendableGraph>
(skeleton::ExtendableGraph &);

template void hugo::checkCompileErasableGraph<skeleton::ErasableGraph>
(skeleton::ErasableGraph &);

//Compile SmartGraph
template void hugo::checkCompileGraph<SmartGraph>(SmartGraph &);
template void hugo::checkCompileGraphFindEdge<SmartGraph>(SmartGraph &);

//Compile SymSmartGraph
//template void hugo::checkCompileGraph<SymSmartGraph>(SymSmartGraph &);
//template void hugo::checkCompileGraphFindEdge<SymSmartGraph>(SymSmartGraph &);

//Compile ListGraph
template void hugo::checkCompileGraph<ListGraph>(ListGraph &);
template void hugo::checkCompileErasableGraph<ListGraph>(ListGraph &);
template void hugo::checkCompileGraphFindEdge<ListGraph>(ListGraph &);


//Compile SymListGraph
//template void hugo::checkCompileGraph<SymListGraph>(SymListGraph &);
//template void hugo::checkCompileErasableGraph<SymListGraph>(SymListGraph &);
//template void hugo::checkCompileGraphFindEdge<SymListGraph>(SymListGraph &);

//Compile FullGraph
template void hugo::checkCompileStaticGraph<FullGraph>(FullGraph &);
template void hugo::checkCompileGraphFindEdge<FullGraph>(FullGraph &);

//Compile EdgeSet <ListGraph>
template void hugo::checkCompileGraph<EdgeSet <ListGraph> >
(EdgeSet <ListGraph> &);
template void hugo::checkCompileGraphEraseEdge<EdgeSet <ListGraph> >
(EdgeSet <ListGraph> &);
template void hugo::checkCompileGraphFindEdge<EdgeSet <ListGraph> >
(EdgeSet <ListGraph> &);

//Compile EdgeSet <NodeSet>
template void hugo::checkCompileGraph<EdgeSet <NodeSet> >(EdgeSet <NodeSet> &);
template void hugo::checkCompileGraphEraseEdge<EdgeSet <NodeSet> >
(EdgeSet <NodeSet> &);
template void hugo::checkCompileGraphFindEdge<EdgeSet <NodeSet> >
(EdgeSet <NodeSet> &);


int main() 
{
  {
    SmartGraph G;
    addPetersen(G);
    bidirPetersen(G);
    checkPetersen(G);
  }
  {
    ListGraph G;
    addPetersen(G);
    bidirPetersen(G);
    checkPetersen(G);
  }
  {
    //    SymSmartGraph G;
    //    addPetersen(G);
    //    checkPetersen(G);
  }
  {
    //    SymListGraph G;
    //    addPetersen(G);
    //    checkPetersen(G);
  }

  ///\file
  ///\todo map tests.
  ///\todo copy constr tests.

  std::cout << __FILE__ ": All tests passed.\n";

  return 0;
}
