// -*- c++ -*-
#ifndef HUGO_DIMACS_H
#define HUGO_DIMACS_H

#include <iostream>
#include <string>
#include <vector>

/// \file
/// \brief Dimacs file format reader.

namespace hugo {

  /// Dimacs flow file format reader function.

  /// This function reads a flow instance from dimacs flow format.
  /// At the beginning \c g is cleared by \c g.clear().
  /// If the data coming from \c is is a max flow problem instance, then 
  /// \c s and \c t will be respectively the source and target nodes 
  /// and \c capacity will contain the edge capacities.
  /// If the data is a shortest path problem instance then \c s will be the 
  /// source node and \c capacity will contain the edge lengths.
  template<typename Graph, typename CapacityMap>
  void readDimacsMaxFlow(std::istream& is, Graph &g, typename Graph::Node &s, typename Graph::Node &t, CapacityMap& capacity) {
    g.clear();
    int cap;
    char d;
    std::string problem;
    char c;
    int i, j;
    std::string str;
    int n, m; 
    typename Graph::Edge e;
    std::vector<typename Graph::Node> nodes;
    while (is>>c) {
      switch (c) {
      case 'c': //comment
	getline(is, str);
	break;
      case 'p': //problem definition
	is >> problem >> n >> m;
	getline(is, str);
	nodes.resize(n+1);
	for (int k=1; k<=n; ++k) nodes[k]=g.addNode();
	break;
      case 'n': //node definition
	if (problem=="sp") { //shortest path problem
	  is >> i;
	  getline(is, str);
	  s=nodes[i];
	}
	if (problem=="max") { //max flow problem
	  is >> i >> d;
	  getline(is, str);
	  if (d=='s') s=nodes[i];
	  if (d=='t') t=nodes[i];
	}
	break;
      case 'a':
	is >> i >> j >> cap;
	getline(is, str);
	e=g.addEdge(nodes[i], nodes[j]);
	capacity.update();
	capacity.set(e, cap);
	break;
      }
    }
  }
  
} //namespace hugo

#endif //HUGO_DIMACS_H
