#include <iostream>
#include <fstream>

#include <lemon/list_graph.h>
#include <lemon/smart_graph.h>
#include <lemon/dimacs.h>
#include <lemon/full_graph.h>
#include <merge_node_graph_wrapper.h>

#include<lemon/concept_check.h>
#include<lemon/concept/graph.h>

using std::cout;
using std::endl;

using namespace lemon;
using namespace lemon::concept;

class Graph3 : ListGraph {
public:
  class Node : public ListGraph::Node { };
  class Edge { };
};

template <typename Graph>
void printGraph(const Graph& g) {
  cout << " nodes:" << endl;
  for (typename Graph::NodeIt n(g); n!=INVALID; ++n) { 
    cout << "  " << g.id(n) << endl;
  }
  cout << " edges:" << endl;
  for (typename Graph::EdgeIt n(g); n!=INVALID; ++n) { 
    cout << "  " << g.id(n) << ": " 
	 << g.id(g.source(n)) << "->" << g.id(g.target(n)) << endl;
  }  
}

int main() {
  {
    cout << "FIRST TEST" << endl;
    typedef SmartGraph Graph1;
    typedef ListGraph Graph2;
    
    {
      checkConcept<StaticGraph, MergeEdgeGraphWrapper<Graph1, Graph2> >();   
      MergeEdgeGraphWrapper<Graph1, Graph2>::printNode(); 
      MergeEdgeGraphWrapper<Graph1, Graph2>::printEdge(); 
      checkConcept<StaticGraph, MergeEdgeGraphWrapper<Graph1, Graph1> >();   
      MergeEdgeGraphWrapper<Graph1, Graph1>::printNode(); 
      MergeEdgeGraphWrapper<Graph1, Graph1>::printEdge(); 
      typedef ResGraphWrapper<Graph1, int, 
	ConstMap<Graph1, int>, ConstMap<Graph1, int> > Graph4;
      checkConcept<StaticGraph, MergeEdgeGraphWrapper<Graph1, Graph4> >();   
      MergeEdgeGraphWrapper<Graph1, Graph4>::printNode(); 
      MergeEdgeGraphWrapper<Graph1, Graph4>::printEdge();
      checkConcept<StaticGraph, MergeEdgeGraphWrapper<Graph4, Graph1> >();   
      MergeEdgeGraphWrapper<Graph4, Graph1>::printNode(); 
      MergeEdgeGraphWrapper<Graph4, Graph1>::printEdge();  
    }
  
    Graph1 g1;
    Graph2 g2;
    typedef MergeEdgeGraphWrapper<Graph1, Graph2> GW;
    GW gw(g1, g2);

    std::ifstream f1("graph1.dim");
    std::ifstream f2("graph2.dim");
    readDimacs(f1, g1);
    readDimacs(f2, g2);
    
    cout << "1st graph" << endl;
    printGraph(g1);

    cout << "2nd graph" << endl;
    printGraph(g2);

    cout << "merged graph" << endl;
    printGraph(gw);

  }


  {
    cout << "SECOND TEST" << endl;
    typedef SmartGraph Graph1;
    {
      checkConcept<StaticGraph, Graph1>();
    }

    Graph1 g1;

    FullGraph pre_g2(2);
    ConstMap<FullGraph::Edge, bool> const_false_map(false);
    typedef EdgeSubGraphWrapper<FullGraph, ConstMap<FullGraph::Edge, bool> >
      Graph2;
    {
      checkConcept<StaticGraph, Graph2>();
    }

    Graph2 g2(pre_g2, const_false_map);

    typedef MergeEdgeGraphWrapper<Graph1, Graph2> GW;
    {
      checkConcept<StaticGraph, GW>();   
    }
    GW gw(g1, g2);
    GW::Node sw;
    GW::Node tw;
    {
      Graph2::NodeIt k(g2);
      sw=GW::Node(INVALID, k, true);
      ++k;
      tw=GW::Node(INVALID, k, true);
    }

    std::ifstream f1("graph2.dim");
    readDimacs(f1, g1);

    cout << "1st graph" << endl;
    printGraph(g1);

    cout << "2nd graph" << endl;
    printGraph(g2);

    cout << "merged graph" << endl;
    printGraph(gw);

    typedef ListGraph Graph3;
    //typedef SmartGraph Graph3;
    Graph3 g3;
    GW::NodeMap<Graph3::Node> gwn(gw);
    Graph3::NodeMap<GW::Node> g3n(g3);
    for (GW::NodeIt n(gw); n!=INVALID; ++n) {
      Graph3::Node m=g3.addNode();
      gwn.set(n, m);
      g3n.set(m, n);
    }

    typedef NewEdgeSetGraphWrapper<GW, Graph3> GWW;
    {
      checkConcept<StaticGraph, GWW>();   
    }

    GWW gww(gw, g3, gwn, g3n);

    for (Graph1::NodeIt n(g1); n!=INVALID; ++n) {
      g3.addEdge(gwn[sw], gwn[GW::Node(n,INVALID,false)]);
    }

//     for (Graph1::NodeIt n(g1); n!=INVALID; ++n) {
//       gww.addEdge(sw, GW::Node(n,INVALID,false));
//     }

    cout << "new edges" << endl;
    printGraph(g3);

    cout << "new edges in the new graph" << endl;
    printGraph(gww);

    typedef AugmentingGraphWrapper<GW, GWW> GWWW;
    {
      checkConcept<StaticGraph, GWWW>();   
    }
    GWWW gwww(gw, gww);

    cout << "new edges merged into the original graph" << endl;
    printGraph(gwww);

  }

}
