#ifndef MARCI_PROPERTY_VECTOR_HH
#define MARCI_PROPERTY_VECTOR_HH

#include <vector>

namespace hugo {

  template <typename iterator>
  int number_of(iterator _it) { 
    int i=0;
    for( ; _it.valid(); ++_it) { ++i; } 
    return i;
  }
  
  template <typename graph_type, typename T>
  class node_property_vector {
    typedef typename graph_type::node_iterator node_iterator;
    typedef typename graph_type::each_node_iterator each_node_iterator;
    graph_type& G; 
    std::vector<T> container;
  public:
    node_property_vector(graph_type& _G) : G(_G) {
      int i=0;
      for(each_node_iterator it=G.first_node(); it.valid(); ++it) ++i;
      container.resize(i); 
    }
    node_property_vector(graph_type& _G, T a) : G(_G) {
      for(each_node_iterator it=G.first_node(); it.valid(); ++it) { container.push_back(a); }
    }
    void put(node_iterator nit, const T& a) { container[G.id(nit)]=a; }
    T get(node_iterator nit) { return container[G.id(nit)]; }
  };

  template <typename graph_type, typename T>
  class edge_property_vector {
    typedef typename graph_type::edge_iterator edge_iterator;
    typedef typename graph_type::each_edge_iterator each_edge_iterator;
    graph_type& G; 
    std::vector<T> container;
  public:
    edge_property_vector(graph_type& _G) : G(_G) {
      int i=0;
      for(each_edge_iterator it=G.first_edge(); it.valid(); ++it) ++i;
      container.resize(i); 
    }
    edge_property_vector(graph_type& _G, T a) : G(_G) {
      for(each_edge_iterator it=G.first_edge(); it.valid(); ++it) { 
	container.push_back(a); 
      }
    }
    void put(edge_iterator eit, const T& a) { container[G.id(eit)]=a; }
    T get(edge_iterator eit) { return container[G.id(eit)]; }
  };

} // namespace hugo

#endif //MARCI_PROPERTY_VECTOR_HH
