// -*- c++ -*-
#include <iostream>
#include <fstream>
#include <vector>
#include <cstdlib>

#include <list_graph.h>
//#include <smart_graph.h>
//#include <dimacs.h>
#include <time_measure.h>
#include <for_each_macros.h>
#include <bfs_iterator.h>
#include <bipartite_graph_wrapper.h>
#include <maps.h>
#include <max_flow.h>

/**
 * Inicializalja a veletlenszamgeneratort.
 * Figyelem, ez nem jo igazi random szamokhoz,
 * erre ne bizzad a titkaidat!
 */
void random_init()
{
	unsigned int seed = getpid();
	seed |= seed << 15;
	seed ^= time(0);

	srand(seed);
}

/**
 * Egy veletlen int-et ad vissza 0 es m-1 kozott.
 */
int random(int m)
{
  return int( double(m) * rand() / (RAND_MAX + 1.0) );
}

using namespace hugo;

int main() {
  //typedef UndirListGraph Graph; 
  typedef BipartiteGraph<ListGraph> Graph;
  
  typedef Graph::Node Node;
  typedef Graph::NodeIt NodeIt;
  typedef Graph::Edge Edge;
  typedef Graph::EdgeIt EdgeIt;
  typedef Graph::OutEdgeIt OutEdgeIt;

  Graph g;

  std::vector<Graph::Node> s_nodes;
  std::vector<Graph::Node> t_nodes;

  int a;
  std::cout << "number of nodes in the first color class=";
  std::cin >> a; 
  int b;
  std::cout << "number of nodes in the second color class=";
  std::cin >> b; 
  int m;
  std::cout << "number of edges=";
  std::cin >> m; 
  
  std::cout << "Generatig a random bipartite graph..." << std::endl;
  for (int i=0; i<a; ++i) s_nodes.push_back(g.addNode(false));
  for (int i=0; i<b; ++i) t_nodes.push_back(g.addNode(true));

  random_init();
  for(int i=0; i<m; ++i) {
    g.addEdge(s_nodes[random(a)], t_nodes[random(b)]);
  }

  std::cout << "Edges of the bipartite graph:" << std::endl;
  FOR_EACH_LOC(EdgeIt, e, g) std::cout << e << " ";
  std::cout << std::endl;

  std::cout << "Nodes:" << std::endl;
  FOR_EACH_LOC(Graph::NodeIt, v, g) std::cout << v << " ";
  std::cout << std::endl;
  std::cout << "Nodes in T:" << std::endl;
  FOR_EACH_INC_LOC(Graph::ClassNodeIt, v, g, Graph::T_CLASS) std::cout << v << " ";
  std::cout << std::endl;
  std::cout << "Nodes in S:" << std::endl;
  FOR_EACH_INC_LOC(Graph::ClassNodeIt, v, g, Graph::S_CLASS) std::cout << v << " ";
  std::cout << std::endl;

  std::cout << "Erasing the first node..." << std::endl;
  NodeIt n;
  g.first(n);
  g.erase(n);
  std::cout << "Nodes of the bipartite graph:" << std::endl;
  FOR_EACH_GLOB(n, g) std::cout << n << " ";
  std::cout << std::endl;

  std::cout << "Nodes in T:" << std::endl;
  FOR_EACH_INC_LOC(Graph::ClassNodeIt, v, g, Graph::T_CLASS) std::cout << v << " ";
  std::cout << std::endl;
  std::cout << "Nodes in S:" << std::endl;
  FOR_EACH_INC_LOC(Graph::ClassNodeIt, v, g, Graph::S_CLASS) std::cout << v << " ";
  std::cout << std::endl;

  typedef stGraphWrapper<Graph> stGW;
  stGW stgw(g);
  ConstMap<stGW::Edge, int> const1map(1);

  Timer ts;
  ts.reset();
  stGW::EdgeMap<int> flow(stgw);
  MaxFlow<stGW, int, ConstMap<stGW::Edge, int>, stGW::EdgeMap<int> > 
    max_flow_test(stgw, stgw.S_NODE, stgw.T_NODE, const1map, flow);
  max_flow_test.run();
//  while (max_flow_test.augmentOnShortestPath()) { }
//  typedef ListGraph MutableGraph;
//  while (max_flow_test.augmentOnBlockingFlow1<MutableGraph>()) {
//  while (max_flow_test.augmentOnBlockingFlow2()) {
//   std::cout << max_flow_test.flowValue() << std::endl;
//  }
  std::cout << "max flow value: " << max_flow_test.flowValue() << std::endl;
  std::cout << "elapsed time: " << ts << std::endl;
  FOR_EACH_LOC(stGW::EdgeIt, e, stgw) { 
    if (flow[e]) std::cout << e << std::endl; 
  }
  std::cout << std::endl;

  return 0;
}
