/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2006
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#define NDEBUG

#include <lemon/time_measure.h>
#include <lemon/smart_graph.h>
#include <lemon/graph_utils.h>
#include <lemon/maps.h>
#include <lemon/error.h>

#include <lemon/radix_sort.h>

#include <vector>
#include <algorithm>
#include <cmath>

using namespace std;
using namespace lemon;

void testRadixSort() {
  int n = 10000000;
  vector<int> data(n);
  for (int i = 0; i < n; ++i) {
    data[i] = (int)(1000 * (rand() / (RAND_MAX + 1.0))) - 500;
  }
  radixSort(data.begin(), data.end());
}


void testCounterSort() {
  int n = 10000000;
  vector<int> data(n);
  for (int i = 0; i < n; ++i) {
    data[i] = (int)(1000 * (rand() / (RAND_MAX + 1.0))) - 500;
  }
  counterSort(data.begin(), data.end());
}

void testSort() {
  int n = 10000000;
  vector<int> data(n);
  for (int i = 0; i < n; ++i) {
    data[i] = (int)(1000 * (rand() / (RAND_MAX + 1.0))) - 500;
  }
  sort(data.begin(), data.end());
}

void testStableSort() {
  int n = 10000000;
  vector<int> data(n);
  for (int i = 0; i < n; ++i) {
    data[i] = (int)(1000 * (rand() / (RAND_MAX + 1.0))) - 500;
  }
  stable_sort(data.begin(), data.end());
}

void testSorts() {
  {
    int n = 10000000;
    vector<int> data(n);
  }
  cout << "Radix sort: " << runningTimeTest(testRadixSort, 60) << endl;
  cout << "Counter sort: " << runningTimeTest(testCounterSort, 60) << endl;
  cout << "Standard sort: " << runningTimeTest(testSort, 60) << endl;
  cout << "Stable sort: " << runningTimeTest(testStableSort, 60) << endl;
}


int main() {
  testSorts();
  return 0;
}
