/* -*- C++ -*-
 * src/lemon/lp_cplex.h - Part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2005 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#ifndef LEMON_LP_CPLEX_H
#define LEMON_LP_CPLEX_H

///\file
///\brief Header of the LEMON-CPLEX lp solver interface.

#include <lemon/lp_base.h>
extern "C" {
#include <ilcplex/cplex.h>
}

namespace lemon {


  /// \brief Wrapper for GLPK solver
  /// 
  /// This class implements a lemon wrapper for GLPK.
  class LpCplex : public LpSolverBase {

  public:

    typedef LpSolverBase Parent;
    
    /// \e
    int status;
    CPXENVptr env;
    CPXLPptr lp;


    /// \e
    LpCplex() : Parent() {
      env = NULL;
      lp = NULL;
      env = CPXopenCPLEXdevelop(&status);     
//     if (Env == NULL)
//     {
//          fprintf(stderr,"A CPLEX krnyezet megnyitsa sikertelen.\n");
// 	 CPXgeterrorstring(Env, Status, ErrorMsg);
// 	 fprintf(stderr,"%s",ErrorMsg);
// 	 goto Terminate;
//     }

    // *** A problema ltrehozsa ***
    lp = CPXcreateprob(env, &status, "LP problem");
 
//    if (Problem == NULL)
//     {
// 	fprintf(stderr,"Az LP ltrehozsa sikertelen");
// 	goto Terminate;
//     }
 
    }
    /// \e
    ~LpCplex() {
      status = CPXfreeprob(env,&lp); 
//       if (Status != 0)
// 	{
// 	  fprintf(stderr,"A CPLEX feladat trlse sikertelen.\n");
// 	  CPXgeterrorstring(Env, Status, ErrorMsg);
// 	  fprintf(stderr,"%s",ErrorMsg);
// 	  goto Terminate;
// 	}
       
      status = CPXcloseCPLEX(&env); 
//       if (Status != 0)
// 	{
// 	  fprintf(stderr,"A CPLEX krnyezet bezrsa sikertelen.\n");
// 	  CPXgeterrorstring(Env, Status, ErrorMsg);
// 	  fprintf(stderr,"%s",ErrorMsg);
// 	  goto Terminate;
// 	}
      
    }

  protected:
    virtual int _addCol();
    virtual int _addRow();
    virtual void _setRowCoeffs(int i, 
			       int length,
                               const int   * indices, 
                               const Value   * values );
    virtual void _setColCoeffs(int i, 
			       int length,
                               const int   * indices, 
                               const Value   * values);
    virtual void _setColLowerBound(int i, Value value);
    virtual void _setColUpperBound(int i, Value value);
    virtual void _setRowLowerBound(int i, Value value);
    virtual void _setRowUpperBound(int i, Value value);
    virtual void _setObjCoeff(int i, Value obj_coef);
    ///\e
    
    ///\bug Unimplemented
    ///
    virtual SolveExitStatus _solve();
    ///\e

    ///\bug Unimplemented
    ///
    virtual Value _getPrimal(int i);
    ///\e
    
    ///\bug Unimplemented
    ///
    virtual Value _getPrimalValue();
    ///\e
    
    ///\bug Unimplemented
    ///
    virtual SolutionStatus _getPrimalStatus();

    ///\e
    
    ///\bug Unimplemented
    ///
    virtual void _setMax();
    ///\e
    
    ///\bug Unimplemented
    ///
    virtual void _setMin();

  };
} //END OF NAMESPACE LEMON

#endif //LEMON_LP_CPLEX_H

