#include <iostream>
#include <fstream>

#include <list_graph.hh>
#include <dimacs.hh>
#include <preflow_push_max_flow.h>
#include <preflow_push_hl.h>
#include <time_measure.h>

using namespace marci;

// Use a DIMACS max flow file as stdin.
// read_dimacs_demo < dimacs_max_flow_file
int main(int, char **) {
  typedef ListGraph::NodeIt NodeIt;
  typedef ListGraph::EachEdgeIt EachEdgeIt;

  ListGraph G;
  NodeIt s, t;
  ListGraph::EdgeMap<int> cap(G);
  readDimacsMaxFlow(std::cin, G, s, t, cap);

  {
  std::cout << "preflow demo (preflow_push_max_flow by JACINT)..." << std::endl;
  //ListGraph::EdgeMap<int> flow(G); //0 flow

  double pre_time=currTime();
  preflow_push_max_flow<ListGraph, int> max_flow_test(G, s, t, cap);
  max_flow_test.run();
  ListGraph::NodeMap<bool> cut(G); 
  max_flow_test.mincut(cut);
  int cut_value=0;
  for(EachEdgeIt e=G.first<EachEdgeIt>(); e.valid(); ++e) {
    if (cut.get(G.tail(e)) && !cut.get(G.head(e))) cut_value+=cap.get(e);
  }
  double post_time=currTime();
  //std::cout << "maximum flow: "<< std::endl;
  //for(EachEdgeIt e=G.first<EachEdgeIt>(); e.valid(); ++e) { 
  //  std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
  //}
  //std::cout<<std::endl;
  std::cout << "elapsed time: " << post_time-pre_time << " sec"<< std::endl; 
  std::cout << "flow value: "<< max_flow_test.maxflow() << std::endl;
  std::cout << "cut value: "<< cut_value << std::endl;
  }

    {
  std::cout << "preflow demo (preflow_push_hl by JACINT)..." << std::endl;
  //ListGraph::EdgeMap<int> flow(G); //0 flow

  double pre_time=currTime();
  preflow_push_hl<ListGraph, int> max_flow_test(G, s, t, cap);
  max_flow_test.run();
  ListGraph::NodeMap<bool> cut(G);
  max_flow_test.mincut(cut);
  int cut_value=0;
  for(EachEdgeIt e=G.first<EachEdgeIt>(); e.valid(); ++e) {
    if (cut.get(G.tail(e)) && !cut.get(G.head(e))) cut_value+=cap.get(e);
  }
  double post_time=currTime();
  //std::cout << "maximum flow: "<< std::endl;
  //for(EachEdgeIt e=G.first<EachEdgeIt>(); e.valid(); ++e) { 
  //  std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
  //}
  //std::cout<<std::endl;
  std::cout << "elapsed time: " << post_time-pre_time << " sec"<< std::endl; 
  std::cout << "flow value: "<< max_flow_test.maxflow() << std::endl;
  std::cout << "cut value: "<< cut_value << std::endl;
  }


  return 0;
}
