// -*- C++ -*- //

#ifndef GRAPH_DISPLAYER_CANVAS_H
#define GRAPH_DISPLAYER_CANVAS_H

#include <all_include.h>
#include <mapstorage.h>
#include <libgnomecanvasmm.h>
#include <libgnomecanvasmm/polygon.h>

class GraphDisplayerCanvas : public Gnome::Canvas::CanvasAA
{
  typedef Gnome::Canvas::CanvasAA Parent;

public:
  GraphDisplayerCanvas(Graph &, CoordinatesMap &, MapStorage &);
  virtual ~GraphDisplayerCanvas();

  int changeLineWidth (std::string mapname);
  int changeColor (std::string mapname);
  int changeText (std::string mapname);
  int rezoom();

protected:

  virtual bool on_expose_event(GdkEventExpose *);

private:

  ///Event handler function that handles dragging nodes of displayed_graph
  bool event_handler(GdkEvent* e, Node n);

  ///The graph, on which we work
  Graph g;
  ///Map of nodes of planefigure
  Graph::NodeMap<Gnome::Canvas::Ellipse *> nodesmap;
  ///Map of edges of planefigure
  Graph::EdgeMap<Gnome::Canvas::Line *> edgesmap;

  ///Map of texts to write on edges
  Graph::EdgeMap<Gnome::Canvas::Text *> edgetextmap;

  ///Group of graphical elements of displayed_graph
  Gnome::Canvas::Group displayed_graph;

  ///Here we store the maps that can be displayed through properties.
  MapStorage mapstorage;

  ///Indicates whether the button of mouse is pressed or not
  bool isbutton;

  ///At this location was the mousebutton pressed.
  ///It helps to calculate the distance of dragging.
  double clicked_x, clicked_y;

  ///Remembers which Gnome::Canvas::Item was pressed.
  ///this variable is needed, because
  ///1. we cannot query the item at he cursor as fast as it could not cause a Segmentation Fault
  ///2. we would like to handle only ony item per movement, therefore quering it is not a working solution
  Gnome::Canvas::Item * active_item;


};

#endif //GRAPH_DISPLAYER_CANVAS_H
