#include <iostream>


#ifdef HAVE_GLPK
#include <lemon/lp_glpk.h>
#elif HAVE_CPLEX
#include <lemon/lp_cplex.h>
#endif

using namespace lemon;

#ifdef HAVE_GLPK
typedef LpGlpk LpDefault;
#elif HAVE_CPLEX
typedef LpCplex LpDefault;
#endif

int main()
{     
 //The following example is taken from the documentation of the GLPK library.
 //See it in the GLPK reference manual and among the GLPK sample files (sample.c)
  LpDefault lp;
  typedef LpDefault::Row Row;
  typedef LpDefault::Col Col;

  lp.max();

  Col x1 = lp.addCol();
  Col x2 = lp.addCol();
  Col x3 = lp.addCol();

  //One solution
  //   Row p = lp.addRow();
  //   Row q = lp.addRow();
  //   Row r = lp.addRow();
  //   lp.setRow(p,x1+x2+x3 <=100);  
  //   lp.setRow(q,10*x1+4*x2+5*x3<=600);  
  //   lp.setRow(r,2*x1+2*x2+6*x3<=300);  

  //A more elegant one
  //Constraints
  lp.addRow(x1+x2+x3 <=100);  
  lp.addRow(10*x1+4*x2+5*x3<=600);  
  lp.addRow(2*x1+2*x2+6*x3<=300);  
  //Nonnegativity of the variables
  lp.colLowerBound(x1, 0);
  lp.colLowerBound(x2, 0);
  lp.colLowerBound(x3, 0);
  //Objective function
  lp.setObj(10*x1+6*x2+4*x3);
  
  lp.solve();

  if (lp.primalStatus()==LpSolverBase::OPTIMAL){
    printf("Z = %g; x1 = %g; x2 = %g; x3 = %g\n", 
	   lp.primalValue(), 
	   lp.primal(x1), lp.primal(x2), lp.primal(x3));
  }
  else{
    std::cout<<"Optimal solution not found!"<<std::endl;
  }


  //Here comes the same problem written in C using GLPK API routines

//   LPX *lp;
//       int ia[1+1000], ja[1+1000];
//       double ar[1+1000], Z, x1, x2, x3;
// s1:   lp = lpx_create_prob();
// s2:   lpx_set_prob_name(lp, "sample");
// s3:   lpx_set_obj_dir(lp, LPX_MAX);
// s4:   lpx_add_rows(lp, 3);
// s5:   lpx_set_row_name(lp, 1, "p");
// s6:   lpx_set_row_bnds(lp, 1, LPX_UP, 0.0, 100.0);
// s7:   lpx_set_row_name(lp, 2, "q");
// s8:   lpx_set_row_bnds(lp, 2, LPX_UP, 0.0, 600.0);
// s9:   lpx_set_row_name(lp, 3, "r");
// s10:  lpx_set_row_bnds(lp, 3, LPX_UP, 0.0, 300.0);
// s11:  lpx_add_cols(lp, 3);
// s12:  lpx_set_col_name(lp, 1, "x1");
// s13:  lpx_set_col_bnds(lp, 1, LPX_LO, 0.0, 0.0);
// s14:  lpx_set_obj_coef(lp, 1, 10.0);
// s15:  lpx_set_col_name(lp, 2, "x2");
// s16:  lpx_set_col_bnds(lp, 2, LPX_LO, 0.0, 0.0);
// s17:  lpx_set_obj_coef(lp, 2, 6.0);
// s18:  lpx_set_col_name(lp, 3, "x3");
// s19:  lpx_set_col_bnds(lp, 3, LPX_LO, 0.0, 0.0);
// s20:  lpx_set_obj_coef(lp, 3, 4.0);
// s21:  ia[1] = 1, ja[1] = 1, ar[1] =  1.0; /* a[1,1] =  1 */
// s22:  ia[2] = 1, ja[2] = 2, ar[2] =  1.0; /* a[1,2] =  1 */
// s23:  ia[3] = 1, ja[3] = 3, ar[3] =  1.0; /* a[1,3] =  1 */
// s24:  ia[4] = 2, ja[4] = 1, ar[4] = 10.0; /* a[2,1] = 10 */
// s25:  ia[5] = 3, ja[5] = 1, ar[5] =  2.0; /* a[3,1] =  2 */
// s26:  ia[6] = 2, ja[6] = 2, ar[6] =  4.0; /* a[2,2] =  4 */
// s27:  ia[7] = 3, ja[7] = 2, ar[7] =  2.0; /* a[3,2] =  2 */
// s28:  ia[8] = 2, ja[8] = 3, ar[8] =  5.0; /* a[2,3] =  5 */
// s29:  ia[9] = 3, ja[9] = 3, ar[9] =  6.0; /* a[3,3] =  6 */
// s30:  lpx_load_matrix(lp, 9, ia, ja, ar);
// s31:  lpx_simplex(lp);
// s32:  Z = lpx_get_obj_val(lp);
// s33:  x1 = lpx_get_col_prim(lp, 1);
// s34:  x2 = lpx_get_col_prim(lp, 2);
// s35:  x3 = lpx_get_col_prim(lp, 3);
// s36:  printf("\nZ = %g; x1 = %g; x2 = %g; x3 = %g\n", Z, x1, x2, x3);
// s37:  lpx_delete_prob(lp);
//       return 0;

  return 0;
}
