#include<lemon/graph_reader.h>
#include<lemon/list_graph.h>


#ifdef HAVE_GLPK
#include <lemon/lp_glpk.h>
#elif HAVE_CPLEX
#include <lemon/lp_cplex.h>
#endif

using namespace lemon;

#ifdef HAVE_GLPK
typedef LpGlpk LpDefault;
#elif HAVE_CPLEX
typedef LpCplex LpDefault;
#endif


template<class G,class C>
double maxFlow(const G &g,const C &cap,typename G::Node s,typename G::Node t)
{
  LpDefault lp;
  
  typedef G Graph;
  typedef typename G::Node Node;
  typedef typename G::NodeIt NodeIt;
  typedef typename G::Edge Edge;
  typedef typename G::EdgeIt EdgeIt;
  typedef typename G::OutEdgeIt OutEdgeIt;
  typedef typename G::InEdgeIt InEdgeIt;
  
  typename G::template EdgeMap<LpDefault::Col> x(g);
  lp.addColSet(x);
  
  for(EdgeIt e(g);e!=INVALID;++e) {
    lp.colUpperBound(x[e],cap[e]);
    lp.colLowerBound(x[e],0);
  }

  for(NodeIt n(g);n!=INVALID;++n) if(n!=s&&n!=t) {
    LpDefault::Expr ex;
    for(InEdgeIt  e(g,n);e!=INVALID;++e) ex+=x[e];
    for(OutEdgeIt e(g,n);e!=INVALID;++e) ex-=x[e];
    lp.addRow(ex==0);
  }
  {
    LpDefault::Expr ex;
    for(InEdgeIt  e(g,t);e!=INVALID;++e) ex+=x[e];
    for(OutEdgeIt e(g,t);e!=INVALID;++e) ex-=x[e];
    lp.setObj(ex);
  }
  lp.max();

#ifdef HAVE_GLPK
  lp.presolver(true);
  lp.messageLevel(3);
#endif

  lp.solve();

  return lp.primalValue();
}

int main() 
{
  ListGraph g;
  ListGraph::Node s;
  ListGraph::Node t;
  
  ListGraph::EdgeMap<double> cap(g);
  
  GraphReader<ListGraph> reader(std::cin,g);
  reader.addNode("source",s).addNode("target",t)
    .addEdgeMap("capacity",cap).run();
  
  // std::ifstream file("../test/preflow_");
//   readDimacs(file, g, cap, s, t);

  std::cout << "Max flow value = " << maxFlow(g,cap,s,t) << std::endl;

}
