#include "SimAnn.h"
#include <cstdlib>
#include <cmath>
#include <iostream>

class MyController : public SimAnnBase::Controller {
public:
  long MaxIter, MaxNoImpr;
  double af;
  MyController() {
    MaxIter = 500000;
    MaxNoImpr = 20000;
    af = 0.9999;
    T = 1000;
  }
  bool next() {
    T *= af;
    std::cout << T << std::endl;
    return !((sab->getIter() > MaxIter) || (sab->getIter() - sab->getLastImpr() > MaxNoImpr));
  }
  bool accept(double cost) {
    return (drand48() <= exp(cost / T));
  }
};

class MyEntity {
public:
  void init() {}
  double mutate() { return 10.0; }
};

int main() {
  SimAnn<MyEntity> sa;
  MyController c;
  sa.setController(c);
  MyEntity ent;
  sa.setEnt(ent);
  sa.run();
}
