#include <lemon/smart_graph.h>
#include "graph_reader.h"

#include <iostream>
#include <fstream>

using namespace std;
using namespace lemon;

int main() {
  ifstream input("test.lgf");
  SmartGraph graph;
  GraphReader<SmartGraph> reader(input, graph);
  SmartGraph::NodeMap<int> id(graph);
  reader.readNodeMap("id", id);
  SmartGraph::NodeMap<int> cost(graph);
  reader.readNodeMap("cost", cost);
  SmartGraph::NodeMap<string> color(graph);
  reader.readNodeMap("color", color);
  SmartGraph::NodeMap<string> description(graph);
  reader.readNodeMap<QuotedStringReader>("description", description);
  SmartGraph::EdgeMap<char> mmap(graph);
  reader.readEdgeMap("mmap", mmap);
  reader.skipEdgeMap<QuotedStringReader>("description");
  try {
    reader.read();
  } catch (IOException& e) {
    cerr << e.what() << endl;
  } catch (Exception e) {
    cerr << e.what() << endl;
  }
  for (SmartGraph::NodeIt it(graph); it != INVALID; ++it) {
    cout << cost[it] << ' ' << color[it] << ' ' << description[it] << endl;
  }

  for (SmartGraph::EdgeIt it(graph); it != INVALID; ++it) {
    cout << mmap[it] << ' ' << id[graph.source(it)] << ' ' << id[graph.target(it)]  << endl;
  }
  return 0;
}
