#include <iostream>
#include <fstream>

#include <list_graph.h>
#include <dimacs.h>
#include <minlengthpaths.h>
//#include <time_measure.h>

using namespace hugo;

// Use a DIMACS max flow file as stdin.
// read_dimacs_demo < dimacs_max_flow_file
int main(int argc, char ** argv) {
  typedef ListGraph Graph;

  typedef Graph::Node Node;
  //typedef Graph::EachEdgeIt EachEdgeIt;

  Graph G;
  Node s, t;
  Graph::EdgeMap<int> cap(G);
  readDimacsMaxFlow(std::cin, G, s, t, cap);

  std::cout << "preflow demo (ATHOS)..." << std::endl;
  //Graph::EdgeMap<int> flow(G); //0 flow

  //  double pre_time=currTime();

  int k=1;
  if (argc>1)
    k = atoi(argv[1]);
  MinLengthPaths<Graph, Graph::EdgeMap<int> >
    surb_test(G,cap);
  std::cout << surb_test.run(s,t,k) << std::endl;
  std::cout << surb_test.totalLength() << std::endl;
  //preflow_push<Graph, int> max_flow_test(G, s, t, cap);
  //int flow_value=max_flow_test.run();

  //double post_time=currTime();

  //std::cout << "elapsed time: " << post_time-pre_time << " sec"<< std::endl; 
  //std::cout << "flow value: "<< flow_value << std::endl;

  return 0;
}
