AC_DEFUN([LX_ENABLE_DOC],
[
  AC_ARG_ENABLE([doc],
AS_HELP_STRING([--enable-doc@<:@=yes|no|full@:>@], [build the documentation (full enables internal documentation too) @<:@default=yes@:>@])
AS_HELP_STRING([--disable-doc], [do not build the documentation]),
         [], [enable_doc=yes])

  AC_MSG_CHECKING([whether to build the documention])
  case "$enable_doc" in
    yes)
      DOXYGEN_INTERNAL_DOCS=NO
      AC_MSG_RESULT([yes])
      ;;
    full)
      DOXYGEN_INTERNAL_DOCS=YES
      AC_MSG_RESULT([full])
      ;;
    no)
      DOXYGEN_INTERNAL_DOCS=NO
      AC_MSG_RESULT([no])
      ;;
    *)
      AC_MSG_ERROR([bad value $enable_doc for option --enable-doc])
      ;;
  esac
  AC_SUBST(DOXYGEN_INTERNAL_DOCS)
  AM_CONDITIONAL([WANT_DOC], [test x"$enable_doc" != x"no"])
])
