#include <iostream>
#include <vector>

#include <cmath>
#include <cstdlib>

#include <lemon/smart_graph.h>
#include <lemon/graph_writer.h>

using namespace lemon;
using namespace std;

int main(int argc, const char *argv[]) {
  typedef SmartGraph Graph;
  typedef Graph::Node Node;
  typedef Graph::Edge Edge;

  typedef Graph::EdgeMap<int> CapacityMap;

  const int n = argc > 1 ? atoi(argv[1]) : 1000;
  const int e = argc > 2 ? atoi(argv[2]) : (int)(n * log(n));
  const int m = argc > 3 ? atoi(argv[3]) : 100;

  Graph graph;
  CapacityMap capacity(graph);
  vector<Node> nodes;

  for (int i = 0; i < n; ++i) {
    nodes.push_back(graph.addNode());
  }
  for (int i = 0; i < e; ++i) {
    int s = (int)(n * (double)rand() / (RAND_MAX + 1.0));
    int t = (int)(n * (double)rand() / (RAND_MAX + 1.0));
    int c = (int)(m * (double)rand() / (RAND_MAX + 1.0));
    Edge edge = graph.addEdge(nodes[s], nodes[t]);
    capacity[edge] = c;
  }
  int start = (int)(n * (double)rand() / (RAND_MAX + 1.0));
  writeGraph(cout, graph, capacity, nodes[start]);
  return 0;
}
