/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2006
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#ifndef ALL_INCLUDE_H
#define ALL_INCLUDE_H

#include <fstream>
#include <iostream>

#include <vector>

#include <lemon/list_graph.h>
#include <lemon/maps.h>
#include <lemon/error.h>
#include <lemon/dim2.h>

enum {E_WIDTH, E_COLOR, E_TEXT, EDGE_PROPERTY_NUM}; // arc properties;
enum {N_RADIUS, N_COLOR, N_TEXT, NODE_PROPERTY_NUM}; // node properties;
enum {N_MAPS, E_MAPS, ARROWS, PAR, EPS_PROPERTY_NUM}; // eps properties;
enum {MOVE, CREATE_NODE, CREATE_EDGE, ERASER, MAP_EDIT, TOOL_NUM}; // tools;
#define RANGE 3
#define WIN_WIDTH 900
#define WIN_HEIGHT 600
#define MIN_EDGE_WIDTH 2
#define MAX_EDGE_WIDTH 40
#define MIN_NODE_RADIUS 2
#define MAX_NODE_RADIUS 80

#ifndef MAIN_PART
extern std::vector <std::string> arc_property_strings;
extern std::vector <double> arc_property_defaults;
extern std::vector <std::string> node_property_strings;
extern std::vector <double> node_property_defaults;
extern int longest_property_string_length;
#endif //MAIN_PART

using namespace lemon;

typedef lemon::dim2::Point<double> XY;
typedef ListDigraph Digraph;
typedef Digraph::Node Node;
typedef Digraph::Arc Arc;
typedef Digraph::ArcIt ArcIt;
typedef Digraph::InArcIt InArcIt;
typedef Digraph::OutArcIt OutArcIt;
typedef Digraph::NodeIt NodeIt;

const std::string prog_name = "LEMON Digraph Editor";

enum MapType
{
  NUM  = 1 << 0,
  STR  = 1 << 1,
  ALL  = (1 << 0) | (1 << 1)
};

#endif // ALL_INCLUDE_H
