#include <iostream>
#include <string>

#define LEMON_ASSERT_ABORT 0
#include <lemon/error.h>

using namespace std;

void parse_line() {
  throw lemon::DataFormatError("Syntax error");
}

void parse_file(string fn) {
  try {
    parse_line();
  }
  catch(lemon::DataFormatError &e) {
    e.file(fn);
    e.line(5);
    throw;
  }
}

void fail_assert();

int main() {
  try {
    parse_file("input.txt");
  }
  catch(lemon::Exception &e) {
    cerr << "Exception '" << e.exceptionName()
	 << "' caught: " << endl;
    cerr << e.what() << endl;
  }
  catch(exception &e) {
    cerr << "Exception caught: " << endl;
    cerr << e.what() << endl;
  }

  try {
    throw lemon::LogicError();
  }
  catch(lemon::Exception &e) {
    cerr << "Exception '" << e.exceptionName()
	 << "' caught: " << endl;
    cerr << e.what() << endl;
  }

  try {
    fail_assert();
  }
  catch(lemon::Exception &e) {
    cerr << "Exception '" << e.exceptionName()
	 << "' caught: " << endl;
    cerr << e.what() << endl;
  }
  catch(exception &e) {
    cerr << "Exception caught: " << endl;
    cerr << e.what() << endl;
  }

  cerr << endl;

  // assert(1==0);
  LEMON_ASSERT(1==0, "Ellentmondas");
  LEMON_FIXME("Nincs kesz");
}

#undef LEMON_ASSERT_HANDLER
#define LEMON_ASSERT_EXCEPTION

#include <lemon/error.h>

void fail_assert() {
  LEMON_ASSERT(2*2==5, "Marson vagyunk");
}
