// -*- C++ -*-

#include <lemon/undir_graph_extender.h>
#include <lemon/concept/undir_graph.h>
#include <lemon/list_graph.h>
#include <lemon/smart_graph.h>
#include <lemon/full_graph.h>

#include "test_tools.h"


using namespace lemon;
using namespace lemon::concept;


int main() {
  typedef UndirGraphExtender<ListGraphBase> UndirListGraphBase;

  typedef IterableUndirGraphExtender<
    AlterableUndirGraphExtender<UndirListGraphBase> > IterableUndirListGraph;

  typedef MappableUndirGraphExtender<IterableUndirListGraph>
    MappableUndirListGraph;

  typedef ErasableUndirGraphExtender<
    ClearableUndirGraphExtender<
    ExtendableUndirGraphExtender<MappableUndirListGraph> > > Graph;

  checkConcept<BaseIterableUndirGraphConcept, Graph>();
  checkConcept<IterableUndirGraphConcept, Graph>();
  checkConcept<MappableUndirGraphConcept, Graph>();

  checkConcept<UndirGraph, Graph>();
  checkConcept<ErasableUndirGraph, Graph>();

  checkConcept<UndirGraph, UndirListGraph>();
  checkConcept<ErasableUndirGraph, UndirListGraph>();

  checkConcept<UndirGraph, UndirSmartGraph>();
  checkConcept<ExtendableUndirGraph, UndirSmartGraph>();

  checkConcept<UndirGraph, UndirGraph>();

  return 0;
}
