/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2006
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#ifndef LEMON_DEBUG_H
#define LEMON_DEBUG_H

//! \file
//! \brief Basic definitions for debug control.

namespace lemon {

  //! Debug mode for testing/debugging

  //! Use this debug mode if you want exhaustive range and consistency checks.
  //! It also produces verbose debug messages.
  struct DebugOn {
    //! Example: check whether the edges added to a path are adjacent
    static const bool consistensy_check = true;

    static const bool range_check = true;

    //! Examples: initialize maps with some value;
    //! after deleting an item from UnionFindEnum set its value in the
    //! corresponding map to NULL...
    static const bool ensure_safe_state = true;

    static const int verbose = 5;
  };

  //! Debug mode for turning off debug aids.

  //! This debud mode switches off all range and consistency checks,
  //! as well as the debug messages.
  //!
  struct DebugOff {
    static const bool consistensy_check = false;
    static const bool range_check = false;
    static const bool ensure_safe_state = false;
    static const int verbose = 0;
  };

#ifdef DEBUG
  //! The default debug mode.

  //! The default debug mode.
  //!
  typedef DebugOn DefaultDebugMode;
#else
  //! The default debug mode. 

  //! The default debug mode. 
  //!
  typedef DebugOff DefaultDebugMode;
#endif

}
#endif // LEMON_DEBUG_H
