#include <map_win.h>
#include <set>

MapWin::MapWin(const std::string& title, MapStorage & mapst, GraphDisplayerCanvas & grdispc):gdc(grdispc),ms(mapst)
{
  set_title(title);
  set_default_size(400, 200);

  rb_array=new Gtk::RadioButton * [PROPERTY_NUM];
  vbox_r1=new Gtk::VBox[PROPERTY_NUM];
  vbox_r2=new Gtk::VBox[PROPERTY_NUM];
  radios=new Gtk::HBox[PROPERTY_NUM];
  for(int i=0;i<PROPERTY_NUM;i++)
  {
    rb_array[i]=new Gtk::RadioButton[ms.numOfEdgeMaps()+1];

    Gtk::RadioButton::Group group;

    std::map< std::string,Graph::EdgeMap<double> * >::iterator emsi=ms.beginOfEdgeMaps();
    std::set<int> props;

    int actprop;
    for(int j=0;j<ms.numOfEdgeMaps();j++)
    {

      if(emsi->second==&(ms.default_edgemaps[i]))
      {
	actprop=j;
      }
      for(int k=0;k<PROPERTY_NUM;k++)
      {
	if(emsi->second==&(ms.default_edgemaps[k]))
	{
	  props.insert(j);
	}
      }
      emsi++;
    }

    rb_array[i][0].set_group(group);
    rb_array[i][0].set_label("Default");
    rb_array[i][0].signal_clicked().connect( sigc::bind( sigc::bind( sigc::mem_fun(*this, &MapWin::radio_click), 0), i) );
    vbox_r1[i].pack_start(rb_array[i][0]);


    emsi=ms.beginOfEdgeMaps();
    int actpos=1;
    for(int j=0;j<ms.numOfEdgeMaps();j++)
    {
      if( ( props.find(j) )==( props.end() ) )
      {
	rb_array[i][actpos].set_group(group);
	rb_array[i][actpos].set_label(emsi->first);
	rb_array[i][actpos].signal_clicked().connect
	  (
	   sigc::bind( 
	    sigc::bind(
	     sigc::mem_fun(*this, &MapWin::radio_click),
	     actpos
	    ),
	    i
	   ) 
	  );

    	if(actpos<(ms.numOfEdgeMaps()-PROPERTY_NUM+1)/2)
        {
          vbox_r1[i].pack_start(rb_array[i][actpos]);
	}
	else
        {
	  vbox_r2[i].pack_start(rb_array[i][actpos]);
	}
	actpos++;
      }
      emsi++;
    }
    radios[i].pack_start(vbox_r1[i]);
    radios[i].pack_start(vbox_r2[i]);
    notebook.append_page(radios[i], property_strings[i]);
  }

  add(vbox_b);
  vbox_b.pack_start(notebook);

  show_all_children();

}

void MapWin::radio_click(int prop, int actpos)
{
  if(rb_array[prop][actpos].get_active())
  {

    std::string mapname=rb_array[prop][actpos].get_label();

    if(mapname=="Default")
    {
      mapname=property_strings[prop];
    }

    switch(prop)
    {
      case WIDTH:
        gdc.changeLineWidth(mapname);
        break;
      case COLOR:
        gdc.changeColor(mapname);
        break;
      case TEXT:
        gdc.changeText(mapname);
        break;
      default:
        std::cout<<"Error\n";
    }
  }
};
