// -*- C++ -*- //

#ifndef MAIN_WIN_H
#define MAIN_WIN_H

#include <all_include.h>
#include <mapstorage.h>
#include <map_win.h>
#include <libgnomecanvasmm.h>
#include <libgnomecanvasmm/polygon.h>

class MainWin : public Gtk::Window
{
public:
  MainWin(const std::string& title, Graph &, CoordinatesMap &, MapStorage &);

protected:
  //Window of map-showing setup
  MapWin mapwin;

  //Member widgets:
  GraphDisplayerCanvas gd_canvas;

  //ActionGroup for menu
  Glib::RefPtr<Gtk::ActionGroup> ag;

  //UIManager for menu
  Glib::RefPtr<Gtk::UIManager> uim;

  //Container
  Gtk::VBox vbox;

  //Pops up map-setup window
  virtual void showMaps();

  //Exit
  virtual void quit();

  //Refit screen
  virtual void rezoom();

};

#endif //MAIN_WIN_H
